/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.vault.persistence;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultService;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class PersistentVaultService
implements VaultService {
    private final Options options = PersistentVaultService.options();
    private volatile RocksDB db;
    private final Path path;

    public PersistentVaultService(Path path) {
        this.path = path;
    }

    private static Options options() {
        return new Options().setCreateIfMissing(true).setCompressionType(CompressionType.LZ4_COMPRESSION).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setLevelCompactionDynamicLevelBytes(true).setBytesPerSync(0x100000L).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setUseFsync(true).setTableFormatConfig(new BlockBasedTableConfig().setBlockSize(16384L).setCacheIndexAndFilterBlocks(true).setPinL0FilterAndIndexBlocksInCache(true).setFormatVersion(5).setFilterPolicy(new BloomFilter(10.0, false)).setOptimizeFiltersForMemory(true));
    }

    @Override
    public void start() {
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
            this.db = RocksDB.open(this.options, this.path.toString());
        }
        catch (IOException | RocksDBException e) {
            throw new IgniteInternalException(e);
        }
    }

    @Override
    public void close() {
        RocksUtils.closeAll(this.db, this.options);
    }

    @Override
    @Nullable
    public VaultEntry get(ByteArray key) {
        try {
            byte[] value = this.db.get(key.bytes());
            return value == null ? null : new VaultEntry(key, value);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to read data from RocksDB", (Throwable)e);
        }
    }

    @Override
    public void put(ByteArray key, byte @Nullable [] val) {
        try {
            if (val == null) {
                this.db.delete(key.bytes());
            } else {
                this.db.put(key.bytes(), val);
            }
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to write data to RocksDB", (Throwable)e);
        }
    }

    @Override
    public void remove(ByteArray key) {
        try {
            this.db.delete(key.bytes());
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to remove data to RocksDB", (Throwable)e);
        }
    }

    @Override
    public Cursor<VaultEntry> range(ByteArray fromKey, ByteArray toKey) {
        final ReadOptions readOpts = new ReadOptions();
        final Slice upperBound = new Slice(toKey.bytes());
        readOpts.setIterateUpperBound(upperBound);
        RocksIterator it = this.db.newIterator(readOpts);
        it.seek(fromKey.bytes());
        return new RocksIteratorAdapter<VaultEntry>(it){

            @Override
            protected VaultEntry decodeEntry(byte[] key, byte[] value) {
                return new VaultEntry(new ByteArray(key), value);
            }

            @Override
            public void close() {
                super.close();
                RocksUtils.closeAll(readOpts, upperBound);
            }
        };
    }

    @Override
    public void putAll(Map<ByteArray, byte[]> vals) {
        try (WriteBatch writeBatch = new WriteBatch();
             WriteOptions writeOpts = new WriteOptions().setSync(true);){
            for (Map.Entry<ByteArray, byte[]> entry : vals.entrySet()) {
                if (entry.getValue() == null) {
                    writeBatch.delete(entry.getKey().bytes());
                    continue;
                }
                writeBatch.put(entry.getKey().bytes(), entry.getValue());
            }
            this.db.write(writeOpts, writeBatch);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to write data to RocksDB", (Throwable)e);
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

