/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import org.apache.ignite3.internal.components.LogSyncer;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageException;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateMetaRocksDbPartitionStorage;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class TxStateRocksDbSharedStorage
implements IgniteComponent {
    private static final byte[] TX_STATE_CF_NAME;
    private static final byte[] TX_META_CF_NAME;
    private static final int TX_STATE_STORAGE_FLUSH_DELAY = 100;
    private static final IntSupplier TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER;
    static final ByteOrder BYTE_ORDER;
    private volatile RocksDB db;
    private volatile DBOptions dbOptions;
    final WriteOptions writeOptions = new WriteOptions().setDisableWAL(true);
    private final Path dbPath;
    private volatile RocksDbFlusher flusher;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService threadPool;
    private final IntSupplier flushDelaySupplier;
    private final LogSyncer logSyncer;
    private final FailureProcessor failureProcessor;
    private final String nodeName;
    private volatile ColumnFamily txStateColumnFamily;
    private volatile ColumnFamily txStateMetaColumnFamily;

    public TxStateRocksDbSharedStorage(String nodeName, Path dbPath, ScheduledExecutorService scheduledExecutor, ExecutorService threadPool, LogSyncer logSyncer, FailureProcessor failureProcessor) {
        this(nodeName, dbPath, scheduledExecutor, threadPool, logSyncer, failureProcessor, TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER);
    }

    public TxStateRocksDbSharedStorage(String nodeName, Path dbPath, ScheduledExecutorService scheduledExecutor, ExecutorService threadPool, LogSyncer logSyncer, FailureProcessor failureProcessor, IntSupplier flushDelaySupplier) {
        this.dbPath = dbPath;
        this.scheduledExecutor = scheduledExecutor;
        this.threadPool = threadPool;
        this.flushDelaySupplier = flushDelaySupplier;
        this.logSyncer = logSyncer;
        this.failureProcessor = failureProcessor;
        this.nodeName = nodeName;
    }

    RocksDB db() {
        return this.db;
    }

    CompletableFuture<Void> awaitFlush(boolean schedule) {
        return this.flusher.awaitFlush(schedule);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.start();
        return CompletableFutures.nullCompletedFuture();
    }

    private void start() {
        try {
            Files.createDirectories(this.dbPath, new FileAttribute[0]);
            this.flusher = new RocksDbFlusher("tx state storage", this.nodeName, this.busyLock, this.scheduledExecutor, this.threadPool, this.flushDelaySupplier, this.logSyncer, this.failureProcessor, () -> {});
            this.dbOptions = ((DBOptions)new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setAtomicFlush(true).setListeners((List)List.of(this.flusher.listener()))).setAvoidFlushDuringShutdown(true);
            List<ColumnFamilyDescriptor> cfDescriptors = TxStateRocksDbSharedStorage.columnFamilyDescriptors();
            ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>(cfDescriptors.size());
            this.db = RocksDB.open(this.dbOptions, this.dbPath.toString(), cfDescriptors, cfHandles);
            this.txStateColumnFamily = ColumnFamily.wrap(this.db, (ColumnFamilyHandle)cfHandles.get(0));
            this.txStateMetaColumnFamily = ColumnFamily.wrap(this.db, (ColumnFamilyHandle)cfHandles.get(1));
            this.flusher.init(this.db, cfHandles);
        }
        catch (Exception e) {
            throw new TxStateStorageException(ErrorGroups.Common.INTERNAL_ERR, "Could not create transaction state storage", e, new Object[0]);
        }
    }

    private static List<ColumnFamilyDescriptor> columnFamilyDescriptors() {
        return List.of(new ColumnFamilyDescriptor(TX_STATE_CF_NAME), new ColumnFamilyDescriptor(TX_META_CF_NAME));
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        try {
            this.close();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void close() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        RocksDbFlusher flusher = this.flusher;
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        resources.add(flusher == null ? null : flusher::stop);
        resources.add(this.db);
        resources.add(this.dbOptions);
        resources.add(this.writeOptions);
        IgniteUtils.closeAll(resources);
    }

    public ColumnFamily txStateColumnFamily() {
        return this.txStateColumnFamily;
    }

    public ColumnFamily txStateMetaColumnFamily() {
        return this.txStateMetaColumnFamily;
    }

    public void destroyStorage(int tableOrZoneId) {
        byte[] dataStart = ByteBuffer.allocate(4).order(BYTE_ORDER).putInt(tableOrZoneId).array();
        byte[] dataEnd = RocksUtils.incrementPrefix(dataStart);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.deleteRange(this.txStateColumnFamily.handle(), dataStart, dataEnd);
            TxStateMetaRocksDbPartitionStorage.clearForTableOrZone(writeBatch, this.txStateMetaColumnFamily().handle(), tableOrZoneId);
            this.db.write(this.writeOptions, writeBatch);
        }
        catch (Exception e) {
            throw new TxStateStorageException("Failed to destroy the transaction state storage [tableOrZoneId={}]", (Throwable)e, tableOrZoneId);
        }
    }

    public Set<Integer> tableOrZoneIdsOnDisk() {
        HashSet<Integer> ids = new HashSet<Integer>();
        byte[] lastAppliedGlobalPrefix = new byte[]{0};
        try (Slice upperBound = new Slice(RocksUtils.incrementPrefix(lastAppliedGlobalPrefix));
             ReadOptions readOptions = new ReadOptions().setIterateUpperBound(upperBound);
             RocksIterator it = this.txStateMetaColumnFamily.newIterator(readOptions);){
            it.seek(lastAppliedGlobalPrefix);
            while (it.isValid()) {
                byte[] key = it.key();
                int tableOrZoneId = ByteUtils.bytesToInt(key, lastAppliedGlobalPrefix.length);
                ids.add(tableOrZoneId);
                it.next();
            }
            it.status();
        }
        catch (RocksDBException e) {
            throw new TxStateStorageException(ErrorGroups.Common.INTERNAL_ERR, "Cannot get table/zone IDs", e, new Object[0]);
        }
        return Collections.unmodifiableSet(ids);
    }

    @TestOnly
    public void flush() {
        try {
            this.awaitFlush(true).get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TxStateStorageException("Interrupted while waiting for a flush", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TxStateStorageException("Flush failed", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TxStateStorageException("Flush failed to finish in time", (Throwable)e);
        }
    }

    static {
        RocksDB.loadLibrary();
        TX_STATE_CF_NAME = RocksDB.DEFAULT_COLUMN_FAMILY;
        TX_META_CF_NAME = "TX_META".getBytes(StandardCharsets.UTF_8);
        TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER = () -> 100;
        BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    }
}

