/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite3.internal.partition.replicator.ReplicaTableProcessor;
import org.apache.ignite3.internal.partition.replicator.schema.CatalogValidationSchemasSource;
import org.apache.ignite3.internal.raft.ExecutorInclinedRaftCommandRunner;
import org.apache.ignite3.internal.raft.service.RaftCommandRunner;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.schema.SchemaManager;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.secondarystoragebridge.SecondaryStorageBridge;
import org.apache.ignite3.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite3.internal.storage.secondary.SecondaryTableStorage;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.raft.SecondaryPartitionListener;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.NoOpPartitionMvStorageAccessImpl;
import org.apache.ignite3.internal.table.distributed.replicator.SecondaryPartitionReplicaListener;
import org.apache.ignite3.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite3.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;
import org.apache.ignite3.internal.util.SafeTimeValuesTracker;

class SecondaryZoneManager {
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final CatalogService catalogService;
    private final SchemaManager schemaManager;
    private final SecondaryStorageBridge secondaryStorageBridge;
    private final SchemaSyncService executorInclinedSchemaSyncService;
    private final RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry;
    private final LowWatermark lowWatermark;
    private final IgniteSpinBusyLock busyLock;
    private final Executor partitionOperationsExecutor;

    SecondaryZoneManager(PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, CatalogService catalogService, SchemaManager schemaManager, SecondaryStorageBridge secondaryStorageBridge, SchemaSyncService executorInclinedSchemaSyncService, RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry, LowWatermark lowWatermark, IgniteSpinBusyLock busyLock, Executor partitionOperationsExecutor) {
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.catalogService = catalogService;
        this.schemaManager = schemaManager;
        this.secondaryStorageBridge = secondaryStorageBridge;
        this.executorInclinedSchemaSyncService = executorInclinedSchemaSyncService;
        this.remotelyTriggeredResourceRegistry = remotelyTriggeredResourceRegistry;
        this.lowWatermark = lowWatermark;
        this.busyLock = busyLock;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
    }

    void loadTableToSecondaryZoneOnTableCreateHavingZoneReadLock(long causalityToken, TableViewInternal table, CatalogZoneDescriptor secondaryZoneDescriptor, CatalogTableDescriptor tableDescriptor) {
        IgniteUtils.inBusyLock(this.busyLock, () -> {
            for (int partitionIndex = 0; partitionIndex < secondaryZoneDescriptor.partitions(); ++partitionIndex) {
                ZonePartitionId zonePartitionId = new ZonePartitionId(secondaryZoneDescriptor.id(), partitionIndex);
                if (!this.partitionReplicaLifecycleManager.hasLocalPartition(zonePartitionId)) continue;
                this.prepareSecondaryPartitionResourcesAndLoadToZoneReplica(table, zonePartitionId, false);
            }
        });
    }

    CompletableFuture<Void> unloadTableResourcesFromSecondaryZoneReplicaHavingZoneReadLock(TableViewInternal table) {
        int tableId = table.tableId();
        InternalTable internalTable = table.internalTable();
        int partitions = internalTable.partitions();
        Integer secondaryZoneId = internalTable.secondaryZoneId();
        assert (secondaryZoneId != null) : "Secondary zone is null [tableId=" + tableId + "]";
        CompletableFuture[] unloadFutures = new CompletableFuture[partitions];
        for (int partitionIndex = 0; partitionIndex < partitions; ++partitionIndex) {
            ZonePartitionId zonePartitionId = new ZonePartitionId(secondaryZoneId, partitionIndex);
            unloadFutures[partitionIndex] = this.partitionReplicaLifecycleManager.unloadTableResourcesFromZoneReplica(zonePartitionId, tableId);
        }
        return CompletableFuture.allOf(unloadFutures);
    }

    void prepareSecondaryPartitionResourcesAndLoadToZoneReplica(TableViewInternal table, ZonePartitionId zonePartitionId, boolean onNodeRecovery) {
        int tableId = table.tableId();
        int partitionId = zonePartitionId.partitionId();
        InternalTableImpl internalTable = (InternalTableImpl)table.internalTable();
        SafeTimeValuesTracker safeTimeTracker = new SafeTimeValuesTracker(HybridTimestamp.MIN_VALUE);
        internalTable.updateSecondaryPartitionTrackers(partitionId, safeTimeTracker);
        SecondaryTableStorage secondaryTableStorage = internalTable.secondaryStorage();
        assert (secondaryTableStorage != null) : "No secondary storage for table " + tableId;
        SecondaryStorage secondaryStorage = secondaryTableStorage.getOrCreatePartition(partitionId);
        SecondaryPartitionListener raftGroupListener = new SecondaryPartitionListener(secondaryStorage, this.secondaryStorageBridge, tableId, partitionId, safeTimeTracker);
        Function<RaftCommandRunner, ReplicaTableProcessor> createListener = raftClient -> this.createSecondaryReplicaListener(zonePartitionId, (RaftCommandRunner)raftClient, secondaryStorage, safeTimeTracker);
        this.partitionReplicaLifecycleManager.loadTableListenerToZoneReplica(zonePartitionId, tableId, createListener, raftGroupListener, new NoOpPartitionMvStorageAccessImpl(), onNodeRecovery);
    }

    private SecondaryPartitionReplicaListener createSecondaryReplicaListener(ZonePartitionId zonePartitionId, RaftCommandRunner raftClient, SecondaryStorage secondaryStorage, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker) {
        return new SecondaryPartitionReplicaListener(zonePartitionId, new ExecutorInclinedRaftCommandRunner(raftClient, this.partitionOperationsExecutor), secondaryStorage, new CatalogValidationSchemasSource(this.catalogService, this.schemaManager), this.executorInclinedSchemaSyncService, this.catalogService, safeTimeTracker, this.remotelyTriggeredResourceRegistry, this.lowWatermark);
    }
}

