/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.InternalSqlRowImpl;
import org.apache.ignite3.internal.sql.engine.SchemaAwareConverter;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite3.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.PlanId;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite3.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Cloner;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IteratorToDataCursorAdapter;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class SelectCountPlan
implements ExplainablePlan,
ExecutablePlan {
    private static final IgniteLogger LOG = Loggers.forClass(SelectCountPlan.class);
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteSelectCount selectCountNode;
    private final List<RexNode> expressions;
    private final ResultSetMetadata metadata;
    private final ParameterMetadata parameterMetadata;

    SelectCountPlan(PlanId id, int catalogVersion, IgniteSelectCount getCount, ResultSetMetadata resultSetMetadata, ParameterMetadata parameterMetadata) {
        this.id = id;
        this.selectCountNode = getCount;
        this.expressions = getCount.expressions();
        this.catalogVersion = catalogVersion;
        this.metadata = resultSetMetadata;
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    public <RowT> AsyncDataCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction ignored, ExecutableTableRegistry tableRegistry) {
        RelOptTable optTable = this.selectCountNode.getTable();
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        ExecutableTable execTable = tableRegistry.getTable(this.catalogVersion, igniteTable.id());
        CompletableFuture<Long> countFut = execTable.scannableTable().estimatedSize();
        Executor resultExecutor = task -> ctx.execute(task::run, error -> LOG.error("Unexpected error", (Throwable)error));
        CompletionStage result = countFut.thenApplyAsync(rs -> {
            Function<Long, Iterator<InternalSqlRow>> postProcess = this.createResultProjection(ctx);
            return postProcess.apply((Long)rs);
        }, resultExecutor);
        return new IteratorToDataCursorAdapter<InternalSqlRow>((CompletableFuture<Iterator<InternalSqlRow>>)result, Runnable::run);
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.selectCountNode, Commons.cluster());
        return ExplainUtils.toString(clonedRoot);
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.QUERY;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.metadata;
    }

    @Override
    public IgniteSelectCount getRel() {
        return this.selectCountNode;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return null;
    }

    @Override
    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return null;
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public boolean hasCaches() {
        return false;
    }

    private <RowT> Function<Long, Iterator<InternalSqlRow>> createResultProjection(ExecutionContext<RowT> ctx) {
        RelDataType getCountType = new RelDataTypeFactory.Builder((RelDataTypeFactory)ctx.getTypeFactory()).add("ROWCOUNT", SqlTypeName.BIGINT).build();
        RelDataType resultType = this.selectCountNode.getRowType();
        SqlProjection projection = ctx.expressionFactory().project(this.expressions, getCountType);
        RowHandler rowHandler = ctx.rowHandler();
        SchemaAwareConverter<Object, Object> internalTypeConverter = TypeUtils.resultTypeConverter(ctx, resultType);
        return rowCount -> {
            RowSchema rowSchema = RowSchema.builder().addField(NativeTypes.INT64).build();
            Object rowCountRow = ctx.rowHandler().factory(rowSchema).rowBuilder().addField(rowCount).build();
            Object projectRow = projection.project(ctx, rowCountRow);
            return List.of(new InternalSqlRowImpl(projectRow, rowHandler, internalTypeConverter)).iterator();
        };
    }
}

