/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite3.internal.sql.engine.exec.rel.Node;
import org.apache.ignite3.internal.util.CollectionUtils;

public class UnionAllNode<RowT>
extends AbstractNode<RowT>
implements Downstream<RowT> {
    private int curSrc;
    private int waiting;

    public UnionAllNode(ExecutionContext<RowT> ctx) {
        super(ctx);
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        assert (this.sources() != null);
        assert (idx >= 0 && idx < this.sources().size());
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()));
        assert (rowsCnt > 0 && this.waiting == 0);
        this.waiting = rowsCnt;
        this.source().request(this.waiting);
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        --this.waiting;
        this.acquireRow(row);
        this.downstream().push(row);
        this.releaseRow(row);
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        if (++this.curSrc < this.sources().size()) {
            this.source().request(this.waiting);
        } else {
            this.waiting = -1;
            this.downstream().end();
        }
    }

    @Override
    protected void rewindInternal() {
        this.curSrc = 0;
        this.waiting = 0;
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", waiting=").app(this.waiting).app(", currentSource=").app(this.curSrc);
    }

    private Node<RowT> source() {
        return this.sources().get(this.curSrc);
    }
}

