/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.lang.InternalTuple;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.InvalidTypeException;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AccumulatorStateEncodingSchema;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite3.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

final class AccumulatorsStateCodec {
    private final List<TypeSpec> types;
    private final List<Accumulator> accs;
    private final int numElements;
    private final int minEstimatedSize;

    AccumulatorsStateCodec(RowSchema argumentSchema, List<Accumulator> accs) {
        if (argumentSchema.fields().size() != accs.size()) {
            throw new IllegalArgumentException("Number of fields in schema and number of accumulators do not match");
        }
        this.types = argumentSchema.fields();
        this.accs = accs;
        int numElements = 0;
        int minEstimatedSize = 0;
        for (int i = 0; i < accs.size(); ++i) {
            NativeType nativeType;
            Accumulator acc = accs.get(i);
            TypeSpec typeSpec = this.types.get(i);
            numElements += acc.stateEncodingSchema().elementCount();
            if (!acc.stateEncodingSchema().nativeEncoding() || (nativeType = RowSchemaTypes.toNativeType(typeSpec)) == null) continue;
            minEstimatedSize += nativeType.sizeInBytes();
        }
        this.numElements = numElements;
        this.minEstimatedSize = minEstimatedSize;
    }

    int minEstimatedSize() {
        return this.minEstimatedSize;
    }

    ByteBuffer encode(AccumulatorsState accState) {
        ByteBuffer noValueMask = this.encodeNoValueMask(accState);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.numElements);
        for (int i = 0; i < this.accs.size(); ++i) {
            Accumulator acc = this.accs.get(i);
            AccumulatorStateEncodingSchema encodingSchema = acc.stateEncodingSchema();
            accState.setIndex(i);
            Object val = accState.get();
            if (encodingSchema.nativeEncoding()) {
                TypeSpec typeSpec = this.types.get(i);
                AccumulatorsStateCodec.encodeNativeTypeValue(typeSpec, val, builder);
                continue;
            }
            AccumulatorsStateCodec.encodeCustomTypeValue(val, acc, builder);
        }
        ByteBuffer tupleBuf = builder.build();
        ByteBuffer outputBuf = ByteBuffer.allocate(noValueMask.capacity() + tupleBuf.capacity()).order(BinaryTupleParser.ORDER);
        outputBuf.put(noValueMask);
        outputBuf.put(tupleBuf);
        outputBuf.flip();
        return outputBuf;
    }

    void decode(ByteBuffer input, AccumulatorsState accState) {
        BitSet noValueMask = this.decodeNoValueMask(input);
        ByteBuffer inputTupleBuf = input.position(input.position()).slice().order(BinaryTupleParser.ORDER);
        BinaryTuple tuple = new BinaryTuple(this.numElements, inputTupleBuf);
        assert (accState.size() == this.accs.size()) : "State size do not match";
        int elementIndex = 0;
        for (int i = 0; i < this.accs.size(); ++i) {
            boolean present;
            Accumulator acc = this.accs.get(i);
            AccumulatorStateEncodingSchema encodingSchema = acc.stateEncodingSchema();
            accState.setIndex(i);
            boolean bl = present = !noValueMask.get(i);
            if (present) {
                if (encodingSchema.nativeEncoding()) {
                    TypeSpec typeSpec = this.types.get(i);
                    AccumulatorsStateCodec.decodeNativeTypeValue(accState, typeSpec, tuple, elementIndex);
                } else {
                    AccumulatorsStateCodec.decodeCustomTypeValue(accState, acc, tuple, elementIndex);
                }
            }
            elementIndex += encodingSchema.elementCount();
        }
    }

    private ByteBuffer encodeNoValueMask(AccumulatorsState accState) {
        BitSet bitSet = new BitSet(this.accs.size());
        for (int i = 0; i < this.accs.size(); ++i) {
            accState.setIndex(i);
            if (!accState.hasValue()) {
                bitSet.set(i);
            }
            accState.resetIndex();
        }
        long[] longArray = bitSet.toLongArray();
        ByteBuffer buf = ByteBuffer.allocate(4 + longArray.length * 8).order(BinaryTupleParser.ORDER);
        buf.putInt(longArray.length);
        for (long l : longArray) {
            buf.putLong(l);
        }
        buf.flip();
        return buf;
    }

    private static void encodeNativeTypeValue(TypeSpec typeSpec, @Nullable Object val, BinaryTupleBuilder builder) {
        NativeType nativeType = RowSchemaTypes.toNativeType(typeSpec);
        if (nativeType == null) {
            builder.appendNull();
        } else if (val == null) {
            builder.appendNull();
        } else {
            AccumulatorsStateCodec.writeInternal(val, nativeType, builder);
        }
    }

    private static void encodeCustomTypeValue(@Nullable Object val, Accumulator acc, BinaryTupleBuilder builder) {
        acc.writeState(val, builder);
    }

    private BitSet decodeNoValueMask(ByteBuffer input) {
        int numLongs = input.getInt();
        long[] longArray = new long[numLongs];
        for (int i = 0; i < longArray.length; ++i) {
            longArray[i] = input.getLong();
        }
        BitSet presenceMask = BitSet.valueOf(longArray);
        for (int i = 0; i < this.accs.size(); ++i) {
            if (!presenceMask.get(i)) continue;
            presenceMask.set(i);
        }
        return presenceMask;
    }

    private static void decodeNativeTypeValue(AccumulatorsState accState, TypeSpec typeSpec, BinaryTuple tuple, int index) {
        NativeType nativeType = RowSchemaTypes.toNativeType(typeSpec);
        if (nativeType == null) {
            accState.set(null);
        } else if (tuple.hasNullValue(index)) {
            accState.set(null);
        } else {
            Object internalVal = AccumulatorsStateCodec.readInternalValue(tuple, index, nativeType);
            accState.set(internalVal);
        }
    }

    private static void decodeCustomTypeValue(AccumulatorsState state, Accumulator acc, BinaryTuple tuple, int index) {
        Object decodedState = acc.readState(tuple, index);
        state.set(decodedState);
    }

    private static void writeInternal(Object value, NativeType nativeType, BinaryTupleBuilder builder) {
        switch (nativeType.spec()) {
            case BOOLEAN: {
                builder.appendBoolean((boolean)((Boolean)value));
                return;
            }
            case INT8: {
                builder.appendByte((byte)((Byte)value));
                return;
            }
            case INT16: {
                builder.appendShort((short)((Short)value));
                return;
            }
            case INT32: {
                builder.appendInt((int)((Integer)value));
                return;
            }
            case INT64: {
                builder.appendLong((long)((Long)value));
                return;
            }
            case FLOAT: {
                builder.appendFloat(((Float)value).floatValue());
                return;
            }
            case DOUBLE: {
                builder.appendDouble((double)((Double)value));
                return;
            }
            case DECIMAL: {
                DecimalNativeType decimalNativeType = (DecimalNativeType)nativeType;
                builder.appendDecimalNotNull((BigDecimal)value, decimalNativeType.scale());
                return;
            }
            case UUID: {
                builder.appendUuidNotNull((UUID)value);
                return;
            }
            case BYTE_ARRAY: {
                ByteString b = (ByteString)value;
                builder.appendBytesNotNull(b.getBytes());
                return;
            }
            case STRING: {
                builder.appendStringNotNull((String)value);
                return;
            }
            case DATE: {
                builder.appendInt((Integer)value);
                return;
            }
            case TIME: {
                builder.appendInt((Integer)value);
                return;
            }
            case DATETIME: {
                builder.appendLong((Long)value);
                return;
            }
            case TIMESTAMP: {
                builder.appendLong((Long)value);
                return;
            }
        }
        throw new InvalidTypeException("Unknown type: " + nativeType);
    }

    private static Object readInternalValue(InternalTuple tuple, int index, NativeType nativeType) {
        switch (nativeType.spec()) {
            case INT8: {
                return tuple.byteValue(index);
            }
            case INT16: {
                return tuple.shortValue(index);
            }
            case INT32: {
                return tuple.intValue(index);
            }
            case INT64: {
                return tuple.longValue(index);
            }
            case FLOAT: {
                return Float.valueOf(tuple.floatValue(index));
            }
            case DOUBLE: {
                return tuple.doubleValue(index);
            }
            case DECIMAL: {
                DecimalNativeType decimalNativeType = (DecimalNativeType)nativeType;
                return tuple.decimalValue(index, decimalNativeType.scale());
            }
            case UUID: {
                return tuple.uuidValue(index);
            }
            case STRING: {
                return tuple.stringValue(index);
            }
            case BYTE_ARRAY: {
                byte[] bytes = tuple.bytesValue(index);
                return new ByteString(bytes);
            }
            case DATE: {
                return tuple.intValue(index);
            }
            case TIME: {
                return tuple.intValue(index);
            }
            case DATETIME: {
                return tuple.longValue(index);
            }
            case TIMESTAMP: {
                return tuple.longValue(index);
            }
            case BOOLEAN: {
                return tuple.booleanValue(index);
            }
        }
        throw new InvalidTypeException("Unknown type: " + nativeType);
    }
}

