/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionDependencyResolver;
import org.apache.ignite3.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite3.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite3.internal.sql.engine.exec.ScannableDataSourceProvider;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite3.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScanWithAggregate;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;

public class ExecutionDependencyResolverImpl
implements ExecutionDependencyResolver {
    private final ExecutableTableRegistry registry;
    private final ScannableDataSourceProvider dataSourceProvider;

    public ExecutionDependencyResolverImpl(ExecutableTableRegistry registry, ScannableDataSourceProvider dataSourceProvider) {
        this.registry = registry;
        this.dataSourceProvider = dataSourceProvider;
    }

    @Override
    public ResolvedDependencies resolveDependencies(Iterable<IgniteRel> rels, final int catalogVersion) {
        Int2ObjectOpenHashMap tableMap = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap dataSources = new Int2ObjectOpenHashMap();
        IgniteRelShuttle shuttle = new IgniteRelShuttle((Int2ObjectMap)dataSources, (Int2ObjectMap)tableMap){
            final /* synthetic */ Int2ObjectMap val$dataSources;
            final /* synthetic */ Int2ObjectMap val$tableMap;
            {
                this.val$dataSources = int2ObjectMap;
                this.val$tableMap = int2ObjectMap2;
            }

            @Override
            public IgniteRel visit(IgniteSender rel) {
                IgniteDistribution distribution = TraitUtils.distribution((RelNode)rel);
                this.resolveDistributionFunction(distribution);
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteTrimExchange rel) {
                IgniteDistribution distribution = TraitUtils.distribution((RelNode)rel);
                this.resolveDistributionFunction(distribution);
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableModify rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteIndexScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteTableScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteTableScanWithAggregate rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteSystemViewScan rel) {
                IgniteSystemView view = (IgniteSystemView)rel.getTable().unwrap(IgniteSystemView.class);
                assert (view != null);
                this.val$dataSources.put(view.id(), (Object)ExecutionDependencyResolverImpl.this.dataSourceProvider.forSystemView(view));
                return rel;
            }

            private void resolveDistributionFunction(IgniteDistribution distribution) {
                if (distribution.isTableDistribution()) {
                    int tableId = distribution.tableId();
                    this.resolveTable(catalogVersion, tableId);
                }
            }

            private void resolveTable(int catalogVersion2, int tableId) {
                this.val$tableMap.computeIfAbsent(tableId, id -> ExecutionDependencyResolverImpl.this.registry.getTable(catalogVersion2, tableId));
            }
        };
        for (IgniteRel rel : rels) {
            shuttle.visit(rel);
        }
        return new ResolvedDependencies((Int2ObjectMap<ExecutableTable>)tableMap, (Int2ObjectMap<ScannableDataSource>)dataSources);
    }
}

