/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.license;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.license.License;
import org.apache.ignite3.internal.rest.api.license.LicenseFeatureSet;
import org.apache.ignite3.internal.rest.api.license.LicenseId;
import org.apache.ignite3.internal.rest.api.license.LicenseInfo;
import org.apache.ignite3.internal.rest.api.license.LicenseLimits;

@Controller(value="/management/v1/license")
@Tag(name="licenseManagement")
public interface LicenseApi {
    @Operation(operationId="features", summary="Get license features", description="Get license features available to user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="License features set.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=LicenseFeatureSet.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/features")
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    public CompletableFuture<LicenseFeatureSet> features();

    @Operation(operationId="limits", summary="Get license limits", description="Get limits of the current license.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="License limits.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=LicenseLimits.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/limits")
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    public CompletableFuture<LicenseLimits> limits();

    @Operation(operationId="infos", summary="Get license info", description="Get info fields of the current license.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="License info fields.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=LicenseInfo.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/infos")
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    public CompletableFuture<LicenseInfo> infos();

    @Operation(operationId="id", summary="Get license id", description="Get id of the current license.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="License Id.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=LicenseId.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/id")
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    public CompletableFuture<LicenseId> id();

    @Operation(operationId="id", summary="Get license", description="Get current license.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="License.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=License.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    public CompletableFuture<License> get();

    @Operation(operationId="applyNewLicense", summary="Apply new License", description="Applies provided license.")
    @ApiResponses(value={@ApiResponse(responseCode="200"), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Invalid license provided.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    @Post
    public CompletableFuture<Void> post(@Body License var1);

    @Operation(operationId="applyNewLicenseRaw", summary="Apply new License", description="Applies provided license")
    @ApiResponses(value={@ApiResponse(responseCode="200"), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Invalid license provided.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAuthenticated()"})
    @Consumes(value={"text/plain"})
    @Post(value="/raw")
    public CompletableFuture<Void> postRaw(@Body String var1);
}

