/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="DTO for creating a cluster replication request.")
public class StartStopReplicationRequest {
    private static final String DEFAULT_SCHEMA = "PUBLIC";
    @Schema(description="Schema name for replication.", defaultValue="PUBLIC")
    private final String schemaName;
    @Schema(description="If true, all tables will be replicated.")
    @Nullable
    private final Boolean allTables;
    @Schema(description="List of table names to be replicated.")
    @Nullable
    private final List<String> tables;

    @JsonCreator
    public StartStopReplicationRequest(@JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="allTables") @Nullable Boolean allTables, @JsonProperty(value="tableList") @Nullable List<String> tables) {
        this.schemaName = StringUtils.nullOrBlank(schemaName) ? DEFAULT_SCHEMA : schemaName;
        this.allTables = allTables;
        this.tables = tables;
    }

    @JsonGetter
    public String schemaName() {
        return this.schemaName;
    }

    @JsonGetter
    @Nullable
    public Boolean allTables() {
        return this.allTables;
    }

    @JsonGetter
    @Nullable
    public List<String> tables() {
        return this.tables;
    }
}

