/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.command;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite3.internal.replicator.command.SafeTimeSyncCommandBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesTypeInfos;

class SafeTimeSyncCommandDeserializer
implements MessageDeserializer<SafeTimeSyncCommand> {
    private final SafeTimeSyncCommandBuilder msg;

    SafeTimeSyncCommandDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.safeTimeSyncCommand();
    }

    @Override
    public Class<SafeTimeSyncCommand> klass() {
        return SafeTimeSyncCommand.class;
    }

    @Override
    public SafeTimeSyncCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ReplicaMessagesTypeInfos.safeTimeSyncCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SafeTimeSyncCommand.class);
    }
}

