/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.leases;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.placementdriver.leases.Lease;
import org.apache.ignite3.internal.placementdriver.leases.LeaseBatch;
import org.apache.ignite3.internal.placementdriver.leases.NodesDictionary;
import org.apache.ignite3.internal.replicator.PartitionGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class LeaseBatchSerializer
extends VersionedSerializer<LeaseBatch> {
    public static final LeaseBatchSerializer INSTANCE = new LeaseBatchSerializer();
    private static final int ACCEPTED_MASK = 1;
    private static final int PROLONGABLE_MASK = 2;
    private static final int HAS_PROPOSED_CANDIDATE_MASK = 4;
    private static final int HAS_UNCOMMON_EXPIRATION_TIME_MASK = 8;
    private static final int HAS_EXPIRATION_LOGICAL_PART_MASK = 16;
    private static final int DUMMY_LEASE_MASK = 32;
    private static final int BIT_WIDTH_TO_FIT_IN_HALF_BYTE = 3;
    private static final int MAX_NODES_FOR_COMPACT_MODE = 8;
    private static final int COMPACT_HOLDER_INDEX_MASK = 7;

    @Override
    protected void writeExternalData(LeaseBatch batch, IgniteDataOutput out) throws IOException {
        long minExpirationTimePhysical = LeaseBatchSerializer.minExpirationTimePhysicalPart(batch);
        HybridTimestamp commonExpirationTime = LeaseBatchSerializer.mostFrequentExpirationTime(batch);
        out.writeVarInt(minExpirationTimePhysical);
        out.writeVarInt(commonExpirationTime.getPhysical() - minExpirationTimePhysical);
        out.writeVarInt(commonExpirationTime.getLogical());
        NodesDictionary nodesDictionary = LeaseBatchSerializer.buildNodesDictionary(batch);
        nodesDictionary.writeTo(out);
        List<Lease> tableLeases = batch.leases().stream().filter(lease -> lease.replicationGroupId() instanceof TablePartitionId).collect(Collectors.toList());
        List<Lease> zoneLeases = batch.leases().stream().filter(lease -> lease.replicationGroupId() instanceof ZonePartitionId).collect(Collectors.toList());
        assert (tableLeases.size() + zoneLeases.size() == batch.leases().size()) : "There are " + batch.leases().size() + " leases in total, " + tableLeases.size() + " of them are table leases, " + zoneLeases.size() + " are zone leases, but " + (batch.leases().size() - tableLeases.size() - zoneLeases.size()) + " are neither";
        LeaseBatchSerializer.writePartitionedGroupLeases(tableLeases, minExpirationTimePhysical, commonExpirationTime, nodesDictionary, out);
        LeaseBatchSerializer.writePartitionedGroupLeases(zoneLeases, minExpirationTimePhysical, commonExpirationTime, nodesDictionary, out);
    }

    private static long minExpirationTimePhysicalPart(LeaseBatch batch) {
        long min = HybridTimestamp.MAX_VALUE.getPhysical();
        for (Lease lease : batch.leases()) {
            min = Math.min(min, lease.getExpirationTime().getPhysical());
        }
        return min;
    }

    private static HybridTimestamp mostFrequentExpirationTime(LeaseBatch batch) {
        if (batch.leases().isEmpty()) {
            return HybridTimestamp.MIN_VALUE;
        }
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        for (Lease lease : batch.leases()) {
            counts.mergeInt((Object)lease.getExpirationTime(), 1, Integer::sum);
        }
        HybridTimestamp commonExpirationTime = HybridTimestamp.MIN_VALUE;
        int maxCount = -1;
        for (Object2IntMap.Entry entry : counts.object2IntEntrySet()) {
            if (entry.getIntValue() <= maxCount) continue;
            commonExpirationTime = (HybridTimestamp)entry.getKey();
            maxCount = entry.getIntValue();
        }
        return commonExpirationTime;
    }

    private static NodesDictionary buildNodesDictionary(LeaseBatch batch) {
        NodesDictionary nodesDictionary = new NodesDictionary();
        for (Lease lease : batch.leases()) {
            if (lease.getLeaseholderId() != null) {
                assert (lease.getLeaseholder() != null) : lease;
                nodesDictionary.putNode(lease.getLeaseholderId(), lease.getLeaseholder());
            }
            if (lease.proposedCandidate() == null) continue;
            nodesDictionary.putName(lease.proposedCandidate());
        }
        return nodesDictionary;
    }

    private static void writePartitionedGroupLeases(List<Lease> leases, long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, IgniteDataOutput out) throws IOException {
        Map leasesByObjectId = leases.stream().collect(Collectors.groupingBy(lease -> LeaseBatchSerializer.partitionedGroupIdFrom(lease).objectId(), TreeMap::new, Collectors.toList()));
        out.writeVarInt(leasesByObjectId.size());
        int objectIdBase = 0;
        for (Map.Entry entry : leasesByObjectId.entrySet()) {
            int objectId = (Integer)entry.getKey();
            List objectLeases = (List)entry.getValue();
            objectIdBase = LeaseBatchSerializer.writeLeasesForObject(objectId, objectLeases, minExpirationTimePhysical, commonExpirationTime, nodesDictionary, out, objectIdBase);
        }
    }

    private static PartitionGroupId partitionedGroupIdFrom(Lease lease) {
        return (PartitionGroupId)lease.replicationGroupId();
    }

    private static int writeLeasesForObject(int objectId, List<Lease> objectLeases, long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, IgniteDataOutput out, int objectIdBase) throws IOException {
        objectLeases.sort(Comparator.comparing(LeaseBatchSerializer::partitionedGroupIdFrom, Comparator.comparing(PartitionGroupId::partitionId)));
        out.writeVarInt(objectId - objectIdBase);
        int partitionCount = LeaseBatchSerializer.partitionedGroupIdFrom(objectLeases.get(objectLeases.size() - 1)).partitionId() + 1;
        out.writeVarInt(partitionCount);
        int partitionId = 0;
        for (Lease lease : objectLeases) {
            partitionId = LeaseBatchSerializer.writeLease(lease, partitionId, minExpirationTimePhysical, commonExpirationTime, nodesDictionary, out);
        }
        return objectId;
    }

    private static int writeLease(Lease lease, int partitionId, long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, IgniteDataOutput out) throws IOException {
        PartitionGroupId groupId = LeaseBatchSerializer.partitionedGroupIdFrom(lease);
        while (partitionId < groupId.partitionId()) {
            out.write(32);
            ++partitionId;
        }
        assert (partitionId == groupId.partitionId()) : "Duplicate partitionId in " + String.valueOf(lease);
        assert (lease.getLeaseholder() != null && lease.getLeaseholderId() != null) : String.valueOf(lease) + " doesn't have a leaseholder";
        assert (lease.getStartTime() != HybridTimestamp.MIN_VALUE) : String.valueOf(lease) + " has illegal start time";
        assert (lease.getExpirationTime() != HybridTimestamp.MIN_VALUE) : String.valueOf(lease) + " has illegal expiration time";
        UUID leaseHolderId = lease.getLeaseholderId();
        String proposedCandidate = lease.proposedCandidate();
        boolean hasProposedCandidate = proposedCandidate != null;
        boolean hasUncommonExpirationTime = !Objects.equals(lease.getExpirationTime(), commonExpirationTime);
        boolean hasExpirationLogicalPart = lease.getExpirationTime().getLogical() != 0;
        out.write(LeaseBatchSerializer.flags(lease.isAccepted(), lease.isProlongable(), hasProposedCandidate, hasUncommonExpirationTime, hasExpirationLogicalPart));
        if (LeaseBatchSerializer.holderIdAndProposedCandidateFitIn1Byte(nodesDictionary)) {
            int nodesInfo = LeaseBatchSerializer.packNodesInfo(nodesDictionary.getNodeIndex(leaseHolderId), hasProposedCandidate ? nodesDictionary.getNameIndex(proposedCandidate) : 0);
            out.writeVarInt(nodesInfo);
        } else {
            out.writeVarInt(nodesDictionary.getNodeIndex(leaseHolderId));
            if (hasProposedCandidate) {
                out.writeVarInt(nodesDictionary.getNameIndex(proposedCandidate));
            }
        }
        if (hasUncommonExpirationTime) {
            out.writeVarInt(lease.getExpirationTime().getPhysical() - minExpirationTimePhysical);
            if (hasExpirationLogicalPart) {
                out.writeVarInt(lease.getExpirationTime().getLogical());
            }
        }
        long periodIn = lease.getExpirationTime().getPhysical() - lease.getStartTime().getPhysical();
        out.writeVarInt(periodIn);
        out.writeVarInt(lease.getStartTime().getLogical());
        return partitionId + 1;
    }

    private static int packNodesInfo(int holderNodeIndex, int proposedCandidateNameIndex) {
        assert (holderNodeIndex < 8) : holderNodeIndex;
        assert (proposedCandidateNameIndex < 8) : proposedCandidateNameIndex;
        return holderNodeIndex | proposedCandidateNameIndex << 3;
    }

    private static boolean holderIdAndProposedCandidateFitIn1Byte(NodesDictionary dictionary) {
        return dictionary.nameCount() <= 8;
    }

    private static int flags(boolean accepted, boolean prolongable, boolean hasProposedCandidate, boolean hasUncommonExpirationTime, boolean hasExpirationLogicalPart) {
        return (accepted ? 1 : 0) | (prolongable ? 2 : 0) | (hasProposedCandidate ? 4 : 0) | (hasUncommonExpirationTime ? 8 : 0) | (hasExpirationLogicalPart ? 16 : 0);
    }

    @Override
    protected LeaseBatch readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        long minExpirationTimePhysical = in.readVarInt();
        HybridTimestamp commonExpirationTime = new HybridTimestamp(minExpirationTimePhysical + in.readVarInt(), in.readVarIntAsInt());
        NodesDictionary nodesDictionary = NodesDictionary.readFrom(in);
        ArrayList<Lease> leases = new ArrayList<Lease>();
        LeaseBatchSerializer.readPartitionedGroupLeases(minExpirationTimePhysical, commonExpirationTime, nodesDictionary, leases, in, TablePartitionId::new);
        if (in.available() > 0) {
            LeaseBatchSerializer.readPartitionedGroupLeases(minExpirationTimePhysical, commonExpirationTime, nodesDictionary, leases, in, ZonePartitionId::new);
        }
        return new LeaseBatch(leases);
    }

    private static void readPartitionedGroupLeases(long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, List<Lease> leases, IgniteDataInput in, GroupIdFactory groupIdFactory) throws IOException {
        int objectCount = in.readVarIntAsInt();
        int objectIdBase = 0;
        for (int i = 0; i < objectCount; ++i) {
            objectIdBase = LeaseBatchSerializer.readLeasesForObject(minExpirationTimePhysical, commonExpirationTime, nodesDictionary, leases, in, groupIdFactory, objectIdBase);
        }
    }

    private static int readLeasesForObject(long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, List<Lease> leases, IgniteDataInput in, GroupIdFactory groupIdFactory, int objectIdBase) throws IOException {
        int objectId = objectIdBase + in.readVarIntAsInt();
        int partitionCount = in.readVarIntAsInt();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            Lease lease = LeaseBatchSerializer.readLeaseForPartition(partitionId, objectId, minExpirationTimePhysical, commonExpirationTime, nodesDictionary, in, groupIdFactory);
            if (lease == null) continue;
            leases.add(lease);
        }
        return objectId;
    }

    @Nullable
    private static Lease readLeaseForPartition(int partitionId, int objectId, long minExpirationTimePhysical, HybridTimestamp commonExpirationTime, NodesDictionary nodesDictionary, IgniteDataInput in, GroupIdFactory groupIdFactory) throws IOException {
        HybridTimestamp expirationTime;
        int holderNodeIndex;
        int flags = in.read();
        if (LeaseBatchSerializer.flagSet(flags, 32)) {
            return null;
        }
        boolean hasProposedCandidate = LeaseBatchSerializer.flagSet(flags, 4);
        int proposedCandidateNodeIndex = -1;
        if (LeaseBatchSerializer.holderIdAndProposedCandidateFitIn1Byte(nodesDictionary)) {
            int nodesInfo = in.readVarIntAsInt();
            holderNodeIndex = LeaseBatchSerializer.unpackHolderNodeIndex(nodesInfo);
            if (hasProposedCandidate) {
                proposedCandidateNodeIndex = LeaseBatchSerializer.unpackProposedCandidateNameIndex(nodesInfo);
            }
        } else {
            holderNodeIndex = in.readVarIntAsInt();
            if (hasProposedCandidate) {
                proposedCandidateNodeIndex = in.readVarIntAsInt();
            }
        }
        UUID leaseHolderId = nodesDictionary.getNodeId(holderNodeIndex);
        String leaseHolder = nodesDictionary.getNodeName(holderNodeIndex);
        String proposedCandidate = null;
        if (hasProposedCandidate) {
            proposedCandidate = nodesDictionary.getName(proposedCandidateNodeIndex);
        }
        if (LeaseBatchSerializer.flagSet(flags, 8)) {
            long expirationPhysical = minExpirationTimePhysical + in.readVarInt();
            int expirationLogical = LeaseBatchSerializer.flagSet(flags, 16) ? in.readVarIntAsInt() : 0;
            expirationTime = new HybridTimestamp(expirationPhysical, expirationLogical);
        } else {
            expirationTime = commonExpirationTime;
        }
        long period = in.readVarInt();
        int startLogical = in.readVarIntAsInt();
        HybridTimestamp startTime = new HybridTimestamp(expirationTime.getPhysical() - period, startLogical);
        return new Lease(leaseHolder, leaseHolderId, startTime, expirationTime, LeaseBatchSerializer.flagSet(flags, 2), LeaseBatchSerializer.flagSet(flags, 1), proposedCandidate, groupIdFactory.create(objectId, partitionId));
    }

    private static int unpackHolderNodeIndex(int nodesInfo) {
        return nodesInfo & 7;
    }

    private static int unpackProposedCandidateNameIndex(int nodesInfo) {
        return nodesInfo >> 3;
    }

    private static boolean flagSet(int flags, int mask) {
        return (flags & mask) != 0;
    }

    @FunctionalInterface
    private static interface GroupIdFactory {
        public PartitionGroupId create(int var1, int var2);
    }
}

