/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.leases;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class Lease
implements ReplicaMeta {
    @Nullable
    private final String leaseholder;
    @Nullable
    private final UUID leaseholderId;
    private final boolean accepted;
    private final HybridTimestamp startTime;
    private final HybridTimestamp expirationTime;
    private final boolean prolongable;
    @Nullable
    private final String proposedCandidate;
    private final ReplicationGroupId replicationGroupId;

    public Lease(@Nullable String leaseholder, @Nullable UUID leaseholderId, HybridTimestamp startTime, HybridTimestamp leaseExpirationTime, ReplicationGroupId replicationGroupId) {
        this(leaseholder, leaseholderId, startTime, leaseExpirationTime, true, false, null, replicationGroupId);
    }

    public Lease(@Nullable String leaseholder, @Nullable UUID leaseholderId, HybridTimestamp startTime, HybridTimestamp leaseExpirationTime, boolean prolong, boolean accepted, @Nullable String proposedCandidate, ReplicationGroupId replicationGroupId) {
        assert (leaseholder == null == (leaseholderId == null)) : "leaseholder=" + leaseholder + ", leaseholderId=" + String.valueOf(leaseholderId);
        this.leaseholder = leaseholder;
        this.leaseholderId = leaseholderId;
        this.startTime = startTime;
        this.expirationTime = leaseExpirationTime;
        this.prolongable = prolong;
        this.accepted = accepted;
        this.replicationGroupId = replicationGroupId;
        this.proposedCandidate = proposedCandidate;
    }

    public Lease prolongLease(HybridTimestamp to) {
        assert (this.accepted) : "The lease should be accepted by leaseholder before prolongation: [lease=" + String.valueOf(this) + ", to=" + String.valueOf(to) + "]";
        assert (this.prolongable) : "The lease should be available to prolong: [lease=" + String.valueOf(this) + ", to=" + String.valueOf(to) + "]";
        return new Lease(this.leaseholder, this.leaseholderId, this.startTime, to, true, true, null, this.replicationGroupId);
    }

    public Lease acceptLease(HybridTimestamp to) {
        assert (!this.accepted) : "The lease is already accepted: " + String.valueOf(this);
        return new Lease(this.leaseholder, this.leaseholderId, this.startTime, to, true, true, null, this.replicationGroupId);
    }

    public Lease denyLease(@Nullable String proposedCandidate) {
        HybridTimestamp newExpirationTime = this.accepted ? this.expirationTime : HybridTimestamp.hybridTimestamp(this.startTime.longValue() + 1L);
        return new Lease(this.leaseholder, this.leaseholderId, this.startTime, newExpirationTime, false, this.accepted, proposedCandidate, this.replicationGroupId);
    }

    @Override
    @Nullable
    public String getLeaseholder() {
        return this.leaseholder;
    }

    @Override
    @Nullable
    public UUID getLeaseholderId() {
        return this.leaseholderId;
    }

    @Override
    public HybridTimestamp getStartTime() {
        return this.startTime;
    }

    @Override
    public HybridTimestamp getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isProlongable() {
        return this.prolongable;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ReplicationGroupId replicationGroupId() {
        return this.replicationGroupId;
    }

    @Nullable
    public String proposedCandidate() {
        return this.proposedCandidate;
    }

    public static Lease emptyLease(ReplicationGroupId replicationGroupId) {
        return new Lease(null, null, HybridTimestamp.MIN_VALUE, HybridTimestamp.MIN_VALUE, replicationGroupId);
    }

    public String toString() {
        return S.toString(Lease.class, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lease other = (Lease)o;
        return this.accepted == other.accepted && this.prolongable == other.prolongable && Objects.equals(this.leaseholder, other.leaseholder) && Objects.equals(this.leaseholderId, other.leaseholderId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.expirationTime, other.expirationTime) && Objects.equals(this.replicationGroupId, other.replicationGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.leaseholder, this.leaseholderId, this.accepted, this.startTime, this.expirationTime, this.prolongable, this.replicationGroupId);
    }
}

