/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;

public interface PartitionDataStorage
extends ManuallyCloseable {
    public int tableId();

    public int partitionId();

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> var1) throws StorageException;

    public void acquirePartitionSnapshotsReadLock();

    public void releasePartitionSnapshotsReadLock();

    default public CompletableFuture<Void> flush() {
        return this.flush(true);
    }

    public CompletableFuture<Void> flush(boolean var1);

    public long lastAppliedIndex();

    public long lastAppliedTerm();

    public void lastApplied(long var1, long var3) throws StorageException;

    public void committedGroupConfiguration(RaftGroupConfiguration var1);

    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration();

    public AddWriteResult addWrite(RowId var1, @Nullable BinaryRow var2, UUID var3, int var4, int var5, boolean var6) throws StorageException;

    public AddWriteCommittedResult addWriteCommitted(RowId var1, @Nullable BinaryRow var2, HybridTimestamp var3) throws StorageException;

    public AbortResult abortWrite(RowId var1, UUID var2) throws StorageException;

    public CommitResult commitWrite(RowId var1, HybridTimestamp var2, UUID var3) throws StorageException;

    public void discard(RowId var1);

    public Cursor<ReadResult> scanVersions(RowId var1) throws StorageException;

    public MvPartitionStorage getStorage();

    @Override
    public void close();

    public PartitionTimestampCursor scan(HybridTimestamp var1) throws StorageException;

    public List<RowUpdateInfo<BinaryRow>> scanUpdateLog(HybridTimestamp var1, RowId var2, HybridTimestamp var3, int var4, EnumSet<TableRowEventType> var5, boolean var6) throws StorageException;

    @Nullable
    public GcEntry peek(HybridTimestamp var1);

    @Nullable
    public BinaryRow vacuum(GcEntry var1);

    public void trimUpdateLog(HybridTimestamp var1, int var2);

    public void updateLease(LeaseInfo var1);

    @Nullable
    public LeaseInfo leaseInfo();
}

