/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteScanRetrieveBatchReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ReadWriteScanRetrieveBatchReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteScanRetrieveBatchReplicaRequest> {
    private final ReadWriteScanRetrieveBatchReplicaRequestBuilder msg;

    ReadWriteScanRetrieveBatchReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteScanRetrieveBatchReplicaRequest();
    }

    @Override
    public Class<ReadWriteScanRetrieveBatchReplicaRequest> klass() {
        return ReadWriteScanRetrieveBatchReplicaRequest.class;
    }

    @Override
    public ReadWriteScanRetrieveBatchReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteScanRetrieveBatchReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int n = reader.readInt("batchSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchSize(n);
                reader.incrementState();
            }
            case 1: {
                BitSet bitSet = reader.readBitSet("columnsToInclude");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (bitSet != null) {
                    this.msg.columnsToInclude(bitSet);
                }
                reader.incrementState();
            }
            case 2: {
                ReplicationGroupIdMessage replicationGroupIdMessage = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (replicationGroupIdMessage != null) {
                    this.msg.commitPartitionId(replicationGroupIdMessage);
                }
                reader.incrementState();
            }
            case 3: {
                UUID uUID = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (uUID != null) {
                    this.msg.coordinatorId(uUID);
                }
                reader.incrementState();
            }
            case 4: {
                Long l = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (l != null) {
                    this.msg.enlistmentConsistencyToken(l);
                }
                reader.incrementState();
            }
            case 5: {
                BinaryTupleMessage binaryTupleMessage = (BinaryTupleMessage)reader.readMessage("exactKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (binaryTupleMessage != null) {
                    this.msg.exactKey(binaryTupleMessage);
                }
                reader.incrementState();
            }
            case 6: {
                int n = reader.readInt("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.flags(n);
                reader.incrementState();
            }
            case 7: {
                boolean bl = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(bl);
                reader.incrementState();
            }
            case 8: {
                ReplicationGroupIdMessage replicationGroupIdMessage = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (replicationGroupIdMessage != null) {
                    this.msg.groupId(replicationGroupIdMessage);
                }
                reader.incrementState();
            }
            case 9: {
                Integer n = reader.readBoxedInt("indexToUse");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (n != null) {
                    this.msg.indexToUse(n);
                }
                reader.incrementState();
            }
            case 10: {
                BinaryTupleMessage binaryTupleMessage = (BinaryTupleMessage)reader.readMessage("lowerBoundPrefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (binaryTupleMessage != null) {
                    this.msg.lowerBoundPrefix(binaryTupleMessage);
                }
                reader.incrementState();
            }
            case 11: {
                long l = reader.readLong("scanId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.scanId(l);
                reader.incrementState();
            }
            case 12: {
                boolean bl = reader.readBoolean("skipDelayedAck");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.skipDelayedAck(bl);
                reader.incrementState();
            }
            case 13: {
                int n = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(n);
                reader.incrementState();
            }
            case 14: {
                HybridTimestamp hybridTimestamp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (hybridTimestamp != null) {
                    this.msg.timestamp(hybridTimestamp);
                }
                reader.incrementState();
            }
            case 15: {
                UUID uUID = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (uUID != null) {
                    this.msg.transactionId(uUID);
                }
                reader.incrementState();
            }
            case 16: {
                BinaryTupleMessage binaryTupleMessage = (BinaryTupleMessage)reader.readMessage("upperBoundPrefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (binaryTupleMessage != null) {
                    this.msg.upperBoundPrefix(binaryTupleMessage);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteScanRetrieveBatchReplicaRequest.class);
    }
}

