/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyStorageOperationReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyStorageOperationReplicaRequestBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlyStorageOperationReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlyStorageOperationReplicaRequest> {
    private final ReadOnlyStorageOperationReplicaRequestBuilder msg;

    ReadOnlyStorageOperationReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyStorageOperationReplicaRequest();
    }

    @Override
    public Class<ReadOnlyStorageOperationReplicaRequest> klass() {
        return ReadOnlyStorageOperationReplicaRequest.class;
    }

    @Override
    public ReadOnlyStorageOperationReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readOnlyStorageOperationReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("batchSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchSize(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.coordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("readTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.readTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                long tmp = reader.readLong("scanId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.scanId(tmp);
                reader.incrementState();
            }
            case 5: {
                byte[] tmp = reader.readByteArray("storageOperationByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.storageOperationByteArray(tmp);
                }
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 8: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 9: {
                boolean tmp = reader.readBoolean("usePrimary");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.usePrimary(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyStorageOperationReplicaRequest.class);
    }
}

