/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateCommandV2Builder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class UpdateCommandV2Deserializer
implements MessageDeserializer<UpdateCommandV2> {
    private final UpdateCommandV2Builder msg;

    UpdateCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.updateCommandV2();
    }

    @Override
    public Class<UpdateCommandV2> klass() {
        return UpdateCommandV2.class;
    }

    @Override
    public UpdateCommandV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.updateCommandV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaseStartTime((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = (TimedBinaryRowMessage)reader.readMessage("messageRowToUpdate");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.messageRowToUpdate((TimedBinaryRowMessage)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("rowUuid");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rowUuid((UUID)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 8: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId(tmp);
                }
                reader.incrementState();
            }
            case 9: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateCommandV2.class);
    }
}

