/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.store;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.store.LongOperationAsyncExecutor;
import org.apache.ignite3.internal.pagememory.persistence.store.PageStore;
import org.jetbrains.annotations.Nullable;

public class GroupPageStoresMap<T extends PageStore> {
    private final ConcurrentHashMap<GroupPartitionId, T> groupPartitionIdPageStore = new ConcurrentHashMap();
    private final LongOperationAsyncExecutor longOperationAsyncExecutor;

    public GroupPageStoresMap(LongOperationAsyncExecutor longOperationAsyncExecutor) {
        this.longOperationAsyncExecutor = longOperationAsyncExecutor;
    }

    @Nullable
    public T put(GroupPartitionId groupPartitionId, T pageStore) {
        return (T)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> this.groupPartitionIdPageStore.put(groupPartitionId, pageStore));
    }

    @Nullable
    public T get(GroupPartitionId groupPartitionId) {
        return (T)((PageStore)this.groupPartitionIdPageStore.get(groupPartitionId));
    }

    @Nullable
    public T remove(GroupPartitionId groupPartitionId) {
        return (T)((PageStore)this.groupPartitionIdPageStore.remove(groupPartitionId));
    }

    public boolean contains(GroupPartitionId groupPartitionId) {
        return this.groupPartitionIdPageStore.containsKey(groupPartitionId);
    }

    public Stream<GroupPartitionPageStore<T>> getAll() {
        return this.groupPartitionIdPageStore.entrySet().stream().map(x$0 -> new GroupPartitionPageStore(x$0));
    }

    public void clear() {
        this.groupPartitionIdPageStore.clear();
    }

    public T compute(GroupPartitionId groupPartitionId, Function<? super T, ? extends T> remappingFunction) {
        return (T)this.groupPartitionIdPageStore.compute(groupPartitionId, (? super K groupPartitionId1, ? super V t) -> (PageStore)remappingFunction.apply(t));
    }

    public static class GroupPartitionPageStore<T> {
        private final GroupPartitionId groupPartitionId;
        private final T pageStore;

        private GroupPartitionPageStore(Map.Entry<GroupPartitionId, T> entry) {
            this.groupPartitionId = entry.getKey();
            this.pageStore = entry.getValue();
        }

        public GroupPartitionId groupPartitionId() {
            return this.groupPartitionId;
        }

        public T pageStore() {
            return this.pageStore;
        }
    }
}

