/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite3.internal.network.recovery.message.ProbeMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class ProbeMessageDeserializer
implements MessageDeserializer<ProbeMessage> {
    private final ProbeMessageBuilder msg;

    ProbeMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.probeMessage();
    }

    @Override
    public Class<ProbeMessage> klass() {
        return ProbeMessage.class;
    }

    @Override
    public ProbeMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.probeMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte tmp = reader.readByte("probe");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.probe(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ProbeMessage.class);
    }
}

