/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.function.Consumer;
import org.apache.ignite3.internal.network.NaiveMessageFormat;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.configuration.AckView;
import org.apache.ignite3.internal.network.handshake.HandshakeManager;
import org.apache.ignite3.internal.network.netty.HandshakeHandler;
import org.apache.ignite3.internal.network.netty.HelloMessageDecoder;
import org.apache.ignite3.internal.network.netty.InNetworkObject;
import org.apache.ignite3.internal.network.netty.InboundDecoder;
import org.apache.ignite3.internal.network.netty.InboundRecoveryHandler;
import org.apache.ignite3.internal.network.netty.InitiatorProtocolSniffer;
import org.apache.ignite3.internal.network.netty.IoExceptionSuppressingHandler;
import org.apache.ignite3.internal.network.netty.MessageHandler;
import org.apache.ignite3.internal.network.netty.OutboundEncoder;
import org.apache.ignite3.internal.network.netty.OutboundRecoveryHandler;
import org.apache.ignite3.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite3.internal.network.serialization.PerSessionSerializationService;

public class PipelineUtils {
    private static final String CHUNKED_WRITE_HANDLER_NAME = "chunked-write-handler";

    public static void setup(ChannelPipeline pipeline, PerSessionSerializationService serializationService, HandshakeManager handshakeManager, Consumer<InNetworkObject> messageListener, SslContext sslContext) {
        pipeline.addFirst("ssl", (ChannelHandler)sslContext.newHandler(pipeline.channel().alloc()));
        PipelineUtils.setup(pipeline, serializationService, handshakeManager, messageListener);
    }

    public static void setup(ChannelPipeline pipeline, PerSessionSerializationService serializationService, HandshakeManager handshakeManager, Consumer<InNetworkObject> messageListener) {
        NaiveMessageFormat messageFormat = new NaiveMessageFormat();
        pipeline.addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
        if (handshakeManager.supportsNewProtocol() && handshakeManager.isInitiator()) {
            pipeline.addLast("initiator-protocol-sniffer", (ChannelHandler)new InitiatorProtocolSniffer(handshakeManager.productVersionSource()));
        }
        pipeline.addLast("inbound-decoder", (ChannelHandler)new InboundDecoder(messageFormat, serializationService));
        pipeline.addLast("handshake-handler", (ChannelHandler)new HandshakeHandler(handshakeManager, messageListener, serializationService));
        pipeline.addLast(CHUNKED_WRITE_HANDLER_NAME, (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("outbound-encoder", (ChannelHandler)new OutboundEncoder(messageFormat, serializationService));
        pipeline.addLast("io-exception-suppressing-handler", (ChannelHandler)new IoExceptionSuppressingHandler());
    }

    public static void afterHandshake(ChannelPipeline pipeline, RecoveryDescriptor descriptor, MessageHandler messageHandler, NetworkMessagesFactory factory, AckView ackCfg) {
        pipeline.addAfter("outbound-encoder", "outbound-recovery-handler", (ChannelHandler)new OutboundRecoveryHandler(descriptor));
        pipeline.addBefore("handshake-handler", "inbound-recovery-handler", (ChannelHandler)new InboundRecoveryHandler(descriptor, factory, ackCfg));
        pipeline.addAfter("handshake-handler", "message-handler", (ChannelHandler)messageHandler);
    }

    public static void addHelloMessageDecoder(ChannelPipeline pipeline) {
        pipeline.addBefore("inbound-decoder", "hello-message-decoder", (ChannelHandler)new HelloMessageDecoder());
    }
}

