/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.metrics.MetricSet;
import org.apache.ignite3.internal.metrics.MetricSnapshot;
import org.apache.ignite3.internal.metrics.MetricSource;
import org.apache.ignite3.internal.metrics.configuration.MetricConfiguration;
import org.apache.ignite3.internal.metrics.exporters.MetricExporter;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.jetbrains.annotations.VisibleForTesting;

public class SecuredMetricManager
implements MetricManager {
    private final MetricManager delegate;
    private final Authorizer authorizer;

    public SecuredMetricManager(MetricManager delegate, Authorizer authorizer) {
        this.delegate = delegate;
        this.authorizer = authorizer;
    }

    @Override
    public MetricSet enable(MetricSource src) {
        return this.authorizer.authorize(Action.ENABLE_METRICS, () -> this.delegate.enable(src));
    }

    @Override
    public MetricSet enable(String srcName) {
        return this.authorizer.authorize(Action.ENABLE_METRICS, () -> this.delegate.enable(srcName));
    }

    @Override
    public void disable(MetricSource src) {
        this.authorizer.authorize(Action.DISABLE_METRICS, () -> this.delegate.disable(src));
    }

    @Override
    public void disable(String srcName) {
        this.authorizer.authorize(Action.DISABLE_METRICS, () -> this.delegate.disable(srcName));
    }

    @Override
    public MetricSnapshot metricSnapshot() {
        return this.authorizer.authorize(Action.READ_METRICS, this.delegate::metricSnapshot);
    }

    @Override
    public Collection<MetricSource> metricSources() {
        return this.authorizer.authorize(Action.LIST_METRICS, this.delegate::metricSources);
    }

    @Override
    public Collection<MetricExporter> enabledExporters() {
        return this.delegate.enabledExporters();
    }

    @Override
    public void configure(MetricConfiguration metricConfiguration, Supplier<UUID> clusterIdSupplier, String nodeName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void registerSource(MetricSource src) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void unregisterSource(MetricSource src) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void unregisterSource(String srcName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    @VisibleForTesting
    public void start(Map<String, MetricExporter> availableExporters) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void start(Iterable<MetricExporter> exporters) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

