/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.MetaStorageInfo;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite3.internal.disaster.system.repair.MetastorageRepair;
import org.apache.ignite3.internal.disaster.system.storage.MetastorageRepairStorage;
import org.apache.ignite3.internal.disaster.system.storage.NoOpMetastorageRepairStorage;
import org.apache.ignite3.internal.event.AbstractEventProducer;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite3.internal.future.OrderingFuture;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metastorage.CompactionRevisionUpdateListener;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.RevisionUpdateListener;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.metastorage.command.response.ChecksumInfo;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.StatementResult;
import org.apache.ignite3.internal.metastorage.impl.ElectionListener;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageEvent;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageEventParameters;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageLeaderElectionListener;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageLearnerManager;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageService;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageServiceImpl;
import org.apache.ignite3.internal.metastorage.impl.MetastorageDivergencyValidator;
import org.apache.ignite3.internal.metastorage.impl.MetastorageGroupMaintenance;
import org.apache.ignite3.internal.metastorage.impl.RecoveryRevisionsListenerImpl;
import org.apache.ignite3.internal.metastorage.impl.raft.MetaStorageSnapshotStorageFactory;
import org.apache.ignite3.internal.metastorage.metrics.MetaStorageMetricSource;
import org.apache.ignite3.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite3.internal.metastorage.server.NotificationEnqueuedListener;
import org.apache.ignite3.internal.metastorage.server.ReadOperationForCompactionTracker;
import org.apache.ignite3.internal.metastorage.server.WatchEventHandlingCallback;
import org.apache.ignite3.internal.metastorage.server.raft.MetaStorageListener;
import org.apache.ignite3.internal.metastorage.server.raft.MetastorageGroupId;
import org.apache.ignite3.internal.metastorage.server.time.ClusterTime;
import org.apache.ignite3.internal.metastorage.server.time.ClusterTimeImpl;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.raft.IndexWithTerm;
import org.apache.ignite3.internal.raft.LeaderElectionListener;
import org.apache.ignite3.internal.raft.Loza;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupOptionsConfigurer;
import org.apache.ignite3.internal.raft.RaftManager;
import org.apache.ignite3.internal.raft.RaftNodeId;
import org.apache.ignite3.internal.raft.client.TopologyAwareRaftGroupService;
import org.apache.ignite3.internal.raft.client.TopologyAwareRaftGroupServiceFactory;
import org.apache.ignite3.internal.raft.server.RaftGroupOptions;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.impl.RaftException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MetaStorageManagerImpl
extends AbstractEventProducer<MetaStorageEvent, MetaStorageEventParameters>
implements MetaStorageManager,
MetastorageGroupMaintenance {
    private static final IgniteLogger LOG = Loggers.forClass(MetaStorageManagerImpl.class);
    private final ClusterService clusterService;
    private final RaftManager raftMgr;
    private final ClusterManagementGroupManager cmgMgr;
    private final LogicalTopologyService logicalTopologyService;
    private final CompletableFuture<MetaStorageServiceImpl> metaStorageSvcFut = new CompletableFuture();
    private final KeyValueStorage storage;
    private final HybridClock clock;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean isStopped = new AtomicBoolean();
    private final CompletableFuture<Revisions> recoveryFinishedFuture = new CompletableFuture();
    private final CompletableFuture<Void> deployWatchesFuture = new CompletableFuture();
    private final ClusterTimeImpl clusterTime;
    private final TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory;
    private final MetricManager metricManager;
    private final MetaStorageMetricSource metaStorageMetricSource;
    private final MetastorageRepairStorage metastorageRepairStorage;
    private final MetastorageRepair metastorageRepair;
    private final Executor ioExecutor;
    private final FailureProcessor failureProcessor;
    private volatile long appliedRevision = 0L;
    private volatile SystemDistributedConfiguration systemConfiguration;
    private final List<ElectionListener> electionListeners = new CopyOnWriteArrayList<ElectionListener>();
    private final RaftGroupOptionsConfigurer raftGroupOptionsConfigurer;
    private final MetaStorageLearnerManager learnerManager;
    private final CompletableFuture<Void> raftNodeStarted = new CompletableFuture();
    private final OrderingFuture<RaftGroupService> raftServiceFuture = new OrderingFuture();
    @Nullable
    private PeersChangeState peersChangeState;
    private final Object peersChangeMutex = new Object();
    private final AtomicReference<IndexWithTerm> lastHandledIndexWithTerm = new AtomicReference<IndexWithTerm>(new IndexWithTerm(0L, 0L));
    private final ReadOperationForCompactionTracker readOperationFromLeaderForCompactionTracker;
    private final MetastorageDivergencyValidator divergencyValidator = new MetastorageDivergencyValidator();
    private final RecoveryRevisionsListenerImpl recoveryRevisionsListener;

    public MetaStorageManagerImpl(ClusterService clusterService, ClusterManagementGroupManager cmgMgr, LogicalTopologyService logicalTopologyService, RaftManager raftMgr, KeyValueStorage storage, HybridClock clock, TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory, MetricManager metricManager, MetastorageRepairStorage metastorageRepairStorage, MetastorageRepair metastorageRepair, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, ReadOperationForCompactionTracker readOperationForCompactionTracker, Executor ioExecutor, FailureProcessor failureProcessor) {
        this.clusterService = clusterService;
        this.raftMgr = raftMgr;
        this.cmgMgr = cmgMgr;
        this.logicalTopologyService = logicalTopologyService;
        this.storage = storage;
        this.clock = clock;
        this.clusterTime = new ClusterTimeImpl(clusterService.nodeName(), this.busyLock, clock, failureProcessor);
        this.metaStorageMetricSource = new MetaStorageMetricSource(this.clusterTime);
        this.topologyAwareRaftGroupServiceFactory = topologyAwareRaftGroupServiceFactory;
        this.metricManager = metricManager;
        this.metastorageRepairStorage = metastorageRepairStorage;
        this.metastorageRepair = metastorageRepair;
        this.raftGroupOptionsConfigurer = raftGroupOptionsConfigurer;
        this.readOperationFromLeaderForCompactionTracker = readOperationForCompactionTracker;
        this.ioExecutor = ioExecutor;
        this.failureProcessor = failureProcessor;
        this.learnerManager = new MetaStorageLearnerManager(this.busyLock, logicalTopologyService, failureProcessor, this.metaStorageSvcFut);
        this.recoveryRevisionsListener = new RecoveryRevisionsListenerImpl(this.busyLock, this.recoveryFinishedFuture);
        storage.setRecoveryRevisionsListener(this.recoveryRevisionsListener);
    }

    @TestOnly
    public MetaStorageManagerImpl(ClusterService clusterService, ClusterManagementGroupManager cmgMgr, LogicalTopologyService logicalTopologyService, RaftManager raftMgr, KeyValueStorage storage, HybridClock clock, TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory, MetricManager metricManager, SystemDistributedConfiguration systemConfiguration, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer) {
        this(clusterService, cmgMgr, logicalTopologyService, raftMgr, storage, clock, topologyAwareRaftGroupServiceFactory, metricManager, systemConfiguration, raftGroupOptionsConfigurer, new ReadOperationForCompactionTracker());
    }

    @TestOnly
    public MetaStorageManagerImpl(ClusterService clusterService, ClusterManagementGroupManager cmgMgr, LogicalTopologyService logicalTopologyService, RaftManager raftMgr, KeyValueStorage storage, HybridClock clock, TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory, MetricManager metricManager, SystemDistributedConfiguration systemConfiguration, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, ReadOperationForCompactionTracker tracker) {
        this(clusterService, cmgMgr, logicalTopologyService, raftMgr, storage, clock, topologyAwareRaftGroupServiceFactory, metricManager, new NoOpMetastorageRepairStorage(), (nodes, mgReplicationFactor) -> CompletableFutures.nullCompletedFuture(), raftGroupOptionsConfigurer, tracker, ForkJoinPool.commonPool(), new FailureManager(new NoOpFailureHandler()));
        this.configure(systemConfiguration);
    }

    public void addElectionListener(ElectionListener listener) {
        this.electionListeners.add(listener);
    }

    public void registerNotificationEnqueuedListener(NotificationEnqueuedListener listener) {
        this.storage.registerNotificationEnqueuedListener(listener);
    }

    private CompletableFuture<?> recover(MetaStorageService service) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> {
            ((CompletableFuture)service.currentRevisions().thenAccept(targetRevisions -> {
                assert (targetRevisions != null);
                LOG.info("Performing MetaStorage recovery: [from={}, to={}]", this.storage.revisions(), targetRevisions);
                this.recoveryRevisionsListener.setTargetRevisions(targetRevisions.toRevisions());
            })).whenComplete((res, throwable) -> {
                if (throwable != null) {
                    this.recoveryFinishedFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return ((CompletableFuture)this.recoveryFinishedFuture.thenAccept(revisions -> {
                long recoveryRevision;
                this.appliedRevision = recoveryRevision = revisions.revision();
                if (recoveryRevision > 0L) {
                    this.clusterTime.updateSafeTime(this.storage.timestampByRevision(recoveryRevision));
                }
            })).whenComplete((revisions, throwable) -> {
                this.storage.setRecoveryRevisionsListener(null);
                if (throwable != null) {
                    LOG.info("Recovery failed", (Throwable)throwable);
                } else {
                    LOG.info("Finished MetaStorage recovery", new Object[0]);
                }
            });
        });
    }

    private CompletableFuture<MetaStorageServiceImpl> reenterIfNeededAndInitializeMetaStorage(MetaStorageInfo metaStorageInfo, UUID currentClusterId) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.thisNodeDidNotWitnessMetaStorageRepair(metaStorageInfo, currentClusterId)) {
                return this.tryReenteringMetastorage(metaStorageInfo.metaStorageNodes(), currentClusterId).thenCompose(unused -> this.initializeMetastorage(metaStorageInfo));
            }
            return this.initializeMetastorage(metaStorageInfo);
        }, this.ioExecutor).thenCompose(Function.identity());
    }

    private boolean thisNodeDidNotWitnessMetaStorageRepair(MetaStorageInfo metaStorageInfo, UUID currentClusterId) {
        UUID locallyWitnessedRepairClusterId = this.metastorageRepairStorage.readWitnessedMetastorageRepairClusterId();
        return metaStorageInfo.metastorageRepairedInThisClusterIncarnation() && !Objects.equals(locallyWitnessedRepairClusterId, currentClusterId);
    }

    private CompletableFuture<Void> tryReenteringMetastorage(Set<String> metastorageNodes, UUID currentClusterId) {
        LOG.info("Trying to reenter Metastorage group", new Object[0]);
        return this.validateMetastorageForDivergence(metastorageNodes).thenRunAsync(() -> this.prepareMetaStorageReentry(currentClusterId), this.ioExecutor);
    }

    private CompletableFuture<Void> validateMetastorageForDivergence(Set<String> metastorageNodes) {
        long localRevision = this.storage.revision();
        if (localRevision == 0L) {
            return CompletableFutures.nullCompletedFuture();
        }
        long localChecksum = this.storage.checksum(localRevision);
        return this.doWithOneOffRaftGroupService(PeersAndLearners.fromConsistentIds(metastorageNodes), raftClient -> this.createMetaStorageService((RaftGroupService)raftClient).checksum(localRevision).thenAccept(leaderChecksumInfo -> {
            LOG.info("Validating Metastorage for divergence [localRevision={}, localChecksum={}, leaderChecksumInfo={}", localRevision, localChecksum, leaderChecksumInfo);
            this.divergencyValidator.validate(localRevision, localChecksum, (ChecksumInfo)leaderChecksumInfo);
            LOG.info("Metastorage did not diverge, proceeding", new Object[0]);
        }));
    }

    private void prepareMetaStorageReentry(UUID currentClusterId) {
        LOG.info("Preparing storages for reentry [clusterId={}]", currentClusterId);
        try {
            this.destroyRaftAndStateMachineStorages();
        }
        catch (NodeStoppingException e) {
            throw new RuntimeException(e);
        }
        this.saveWitnessedMetastorageRepairClusterIdLocally(currentClusterId);
    }

    private void destroyRaftAndStateMachineStorages() throws NodeStoppingException {
        this.raftMgr.destroyRaftNodeStorages(this.raftNodeId(), this.raftGroupOptionsConfigurer);
        this.storage.clear();
    }

    private void saveWitnessedMetastorageRepairClusterIdLocally(UUID currentClusterId) {
        assert (currentClusterId != null);
        this.metastorageRepairStorage.saveWitnessedMetastorageRepairClusterId(currentClusterId);
    }

    private CompletableFuture<MetaStorageServiceImpl> initializeMetastorage(MetaStorageInfo metaStorageInfo) {
        CompletableFuture<? extends RaftGroupService> localRaftServiceFuture;
        String thisNodeName = this.clusterService.nodeName();
        try {
            localRaftServiceFuture = metaStorageInfo.metaStorageNodes().contains(thisNodeName) ? this.startVotingNode(metaStorageInfo) : this.startLearnerNode(metaStorageInfo);
        }
        catch (NodeStoppingException e) {
            return CompletableFuture.failedFuture(e);
        }
        return localRaftServiceFuture.thenApply(raftService -> {
            this.raftServiceFuture.complete((RaftGroupService)raftService);
            return this.createMetaStorageService((RaftGroupService)raftService);
        });
    }

    private MetaStorageServiceImpl createMetaStorageService(RaftGroupService raftService) {
        return new MetaStorageServiceImpl(this.clusterService.nodeName(), raftService, this.busyLock, this.clock, this.clusterService.topologyService().localMember().id());
    }

    private CompletableFuture<? extends RaftGroupService> startVotingNode(MetaStorageInfo metaStorageInfo) throws NodeStoppingException {
        PeersAndLearners configuration = PeersAndLearners.fromConsistentIds(metaStorageInfo.metaStorageNodes());
        Peer localPeer = configuration.peer(this.clusterService.nodeName());
        assert (localPeer != null);
        return this.startRaftNode(configuration, localPeer, metaStorageInfo);
    }

    private CompletableFuture<? extends RaftGroupService> startLearnerNode(MetaStorageInfo metaStorageInfo) throws NodeStoppingException {
        String thisNodeName = this.clusterService.nodeName();
        PeersAndLearners configuration = PeersAndLearners.fromConsistentIds(metaStorageInfo.metaStorageNodes(), Set.of(thisNodeName));
        Peer localPeer = configuration.learner(thisNodeName);
        assert (localPeer != null);
        return this.startRaftNode(configuration, localPeer, metaStorageInfo);
    }

    private CompletableFuture<? extends RaftGroupService> startRaftNode(PeersAndLearners configuration, Peer localPeer, MetaStorageInfo metaStorageInfo) {
        SystemDistributedConfiguration currentSystemConfiguration = this.systemConfiguration;
        assert (currentSystemConfiguration != null) : "System configuration has not been set";
        CompletableFuture<TopologyAwareRaftGroupService> serviceFuture = CompletableFuture.supplyAsync(() -> {
            TopologyAwareRaftGroupService service = this.startRaftNodeItself(configuration, localPeer, metaStorageInfo);
            this.raftNodeStarted.complete(null);
            return service;
        }, this.ioExecutor);
        return serviceFuture.thenApply(service -> {
            service.subscribeLeader(this.createLeaderElectionListener(currentSystemConfiguration));
            return service;
        });
    }

    private TopologyAwareRaftGroupService startRaftNodeItself(PeersAndLearners configuration, Peer localPeer, MetaStorageInfo metaStorageInfo) {
        MetaStorageListener raftListener = new MetaStorageListener(this.storage, this.clock, this.clusterTime, this::onConfigurationCommitted, this.metaStorageMetricSource::onIdempotentCacheSizeChange);
        try {
            return this.raftMgr.startSystemRaftGroupNodeAndWaitNodeReady(MetaStorageManagerImpl.raftNodeId(localPeer), configuration, raftListener, (term, configurationTerm, configurationIndex, configuration1) -> this.fireEvent(MetaStorageEvent.ON_LEADER_ELECTED, new MetaStorageEventParameters(term)), this.topologyAwareRaftGroupServiceFactory, options -> {
                this.raftGroupOptionsConfigurer.configure(options);
                RaftGroupOptions groupOptions = (RaftGroupOptions)options;
                groupOptions.externallyEnforcedConfigIndex(metaStorageInfo.metastorageRepairingConfigIndex());
                groupOptions.snapshotStorageFactory(new MetaStorageSnapshotStorageFactory(this.storage));
            });
        }
        catch (NodeStoppingException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(e);
        }
    }

    private LeaderElectionListener createLeaderElectionListener(SystemDistributedConfiguration configuration) {
        return new MetaStorageLeaderElectionListener(this.busyLock, this.clusterService, this.logicalTopologyService, this.failureProcessor, this.metaStorageSvcFut, this.learnerManager, this.clusterTime, (CompletableFuture<SystemDistributedConfiguration>)this.deployWatchesFuture.thenApply(v -> configuration), this.electionListeners, this::peersChangeStateExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peersChangeStateExists() {
        Object object = this.peersChangeMutex;
        synchronized (object) {
            return this.peersChangeState != null;
        }
    }

    private RaftNodeId raftNodeId() {
        return MetaStorageManagerImpl.raftNodeId(new Peer(this.clusterService.nodeName()));
    }

    private static RaftNodeId raftNodeId(Peer localPeer) {
        return new RaftNodeId(MetastorageGroupId.INSTANCE, localPeer);
    }

    private void onConfigurationCommitted(RaftGroupConfiguration configuration) {
        LOG.info("MS configuration committed {}", configuration);
        this.raftServiceFuture.handle((raftService, ex) -> {
            if (ex != null) {
                throw (RuntimeException)ExceptionUtils.sneakyThrow(ex);
            }
            this.updateRaftClientConfigIfEventIsNotStale(configuration, (RaftGroupService)raftService);
            this.handlePeersChange(configuration, (RaftGroupService)raftService);
            return null;
        }).whenComplete((res, ex) -> {
            if (ex != null) {
                this.failureProcessor.process(new FailureContext((Throwable)ex, "Error while handling ConfigurationCommitted event"));
            }
        });
    }

    private void updateRaftClientConfigIfEventIsNotStale(RaftGroupConfiguration configuration, RaftGroupService raftService) {
        IndexWithTerm newIndexWithTerm = new IndexWithTerm(configuration.index(), configuration.term());
        this.lastHandledIndexWithTerm.updateAndGet(existingIndexWithTerm -> {
            if (newIndexWithTerm.compareTo((IndexWithTerm)existingIndexWithTerm) > 0) {
                LOG.info("Updating raftService config to {}", configuration);
                raftService.updateConfiguration(PeersAndLearners.fromConsistentIds(Set.copyOf(configuration.peers()), Set.copyOf(configuration.learners())));
                return newIndexWithTerm;
            }
            LOG.info("Skipping update for stale config {}, actual is {}", newIndexWithTerm, existingIndexWithTerm);
            return existingIndexWithTerm;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePeersChange(RaftGroupConfiguration configuration, RaftGroupService raftService) {
        Object object = this.peersChangeMutex;
        synchronized (object) {
            if (this.peersChangeState == null || configuration.term() <= this.peersChangeState.termBeforeChange) {
                return;
            }
            PeersChangeState currentState = this.peersChangeState;
            if (this.thisNodeIsEstablishedAsLonelyLeader(configuration)) {
                LOG.info("Lonely leader has been established, changing voting set to target set: {}", currentState.targetPeers);
                PeersAndLearners newConfig = PeersAndLearners.fromConsistentIds(currentState.targetPeers);
                raftService.changePeersAndLearners(newConfig, configuration.term()).whenComplete((res, ex) -> {
                    if (ex != null) {
                        Throwable unwrapped = ExceptionUtils.unwrapCause(ex);
                        if (unwrapped instanceof RaftException && ((RaftException)unwrapped).raftError() == RaftError.ECATCHUP) {
                            LOG.error("Error while changing voting set to {}", (Throwable)ex, (Object)currentState.targetPeers);
                        } else if (!ExceptionUtils.hasCause(ex, NodeStoppingException.class)) {
                            String errorMessage = IgniteStringFormatter.format("Error while changing voting set to {}", currentState.targetPeers);
                            this.failureProcessor.process(new FailureContext((Throwable)ex, errorMessage));
                        }
                    } else {
                        LOG.info("Changed voting set successfully to {}", currentState.targetPeers);
                    }
                });
            } else if (MetaStorageManagerImpl.targetVotingSetIsEstablished(configuration, currentState)) {
                LOG.info("Target voting set has been established, unpausing secondary duties", new Object[0]);
                this.peersChangeState = null;
                this.learnerManager.updateLearners(configuration.term()).whenComplete((res, ex) -> {
                    if (ex != null) {
                        String errorMessage = String.format("Error while updating learners as a reaction to commit of %s", configuration);
                        this.failureProcessor.process(new FailureContext((Throwable)ex, errorMessage));
                    }
                });
            }
        }
    }

    private boolean thisNodeIsEstablishedAsLonelyLeader(RaftGroupConfiguration configuration) {
        return configuration.peers().size() == 1 && this.clusterService.nodeName().equals(configuration.peers().get(0));
    }

    private static boolean targetVotingSetIsEstablished(RaftGroupConfiguration configuration, PeersChangeState currentState) {
        return Set.copyOf(configuration.peers()).equals(currentState.targetPeers);
    }

    public final void configure(SystemDistributedConfiguration configuration) {
        this.systemConfiguration = configuration;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.storage.start();
        this.recoveryRevisionsListener.onUpdate(this.storage.revisions());
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.cmgMgr.metaStorageInfo().thenCombine(this.cmgMgr.clusterState(), (x$0, x$1) -> new MetaStorageInfoAndClusterState((MetaStorageInfo)x$0, (ClusterState)x$1))).thenCompose(infoAndState -> {
            LOG.info("Metastorage info on start is {}", infoAndState.metaStorageInfo);
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                CompletableFuture<MetaStorageServiceImpl> completableFuture = this.reenterIfNeededAndInitializeMetaStorage(infoAndState.metaStorageInfo, infoAndState.clusterState.clusterTag().clusterId());
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        })).thenCompose(service -> this.repairMetastorageIfNeeded().thenApply(unused -> service))).thenCompose(service -> this.recover((MetaStorageService)service).thenApply(rev -> service))).whenComplete((service, e) -> {
            if (e != null) {
                this.metaStorageSvcFut.completeExceptionally((Throwable)e);
                this.recoveryFinishedFuture.completeExceptionally((Throwable)e);
            } else {
                assert (service != null);
                this.metaStorageSvcFut.complete((MetaStorageServiceImpl)service);
            }
        });
        this.metricManager.registerSource(this.metaStorageMetricSource);
        this.metricManager.enable(this.metaStorageMetricSource);
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> repairMetastorageIfNeeded() {
        ResetClusterMessage resetClusterMessage = this.metastorageRepairStorage.readVolatileResetClusterMessage();
        if (resetClusterMessage == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!resetClusterMessage.metastorageRepairRequested()) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!this.clusterService.nodeName().equals(resetClusterMessage.conductor())) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.metastorageRepair.repair(Objects.requireNonNull(resetClusterMessage.participatingNodes()), Objects.requireNonNull(resetClusterMessage.metastorageReplicationFactor()));
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.isStopped.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.storage.stopCompaction();
        this.busyLock.block();
        this.deployWatchesFuture.completeExceptionally(new NodeStoppingException());
        this.recoveryFinishedFuture.completeExceptionally(new NodeStoppingException());
        try {
            IgniteUtils.closeAllManually(() -> this.metricManager.unregisterSource(this.metaStorageMetricSource), this.clusterTime, () -> IgniteUtils.failOrConsume(this.metaStorageSvcFut, new NodeStoppingException(), MetaStorageServiceImpl::close), () -> this.raftMgr.stopRaftNodes(MetastorageGroupId.INSTANCE), this.storage);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private static void cleanupMetaStorageServiceFuture(CompletableFuture<MetaStorageServiceImpl> future) {
        future.completeExceptionally(new NodeStoppingException());
        if (future.isCancelled() || future.isCompletedExceptionally()) {
            return;
        }
        assert (future.isDone());
        MetaStorageServiceImpl res = future.join();
        assert (res != null);
        res.close();
    }

    @Override
    public long appliedRevision() {
        return this.appliedRevision;
    }

    @Override
    public void registerPrefixWatch(ByteArray key, WatchListener listener) {
        this.storage.watchRange(key.bytes(), this.storage.nextKey(key.bytes()), this.appliedRevision() + 1L, listener);
    }

    @Override
    public void registerExactWatch(ByteArray key, WatchListener listener) {
        this.storage.watchExact(key.bytes(), this.appliedRevision() + 1L, listener);
    }

    @Override
    public void registerRangeWatch(ByteArray keyFrom, @Nullable ByteArray keyTo, WatchListener listener) {
        this.storage.watchRange(keyFrom.bytes(), keyTo == null ? null : keyTo.bytes(), this.appliedRevision() + 1L, listener);
    }

    @Override
    public void unregisterWatch(WatchListener lsnr) {
        this.storage.removeWatch(lsnr);
    }

    @Override
    public CompletableFuture<Void> deployWatches() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = ((CompletableFuture)this.recoveryFinishedFuture.thenAccept(revisions -> IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.startWatches(revisions.revision() + 1L, new WatchEventHandlingCallback(){

                @Override
                public void onSafeTimeAdvanced(HybridTimestamp newSafeTime) {
                    MetaStorageManagerImpl.this.onSafeTimeAdvanced(newSafeTime);
                }

                @Override
                public void onRevisionApplied(long revision) {
                    MetaStorageManagerImpl.this.onRevisionApplied(revision);
                }
            })))).whenComplete((v, e) -> {
                if (e == null) {
                    this.deployWatchesFuture.complete(null);
                } else {
                    this.deployWatchesFuture.completeExceptionally((Throwable)e);
                }
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Entry> get(ByteArray key) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> this.withTrackReadOperationFromLeaderFuture(this.storage.revision(), () -> this.metaStorageSvcFut.thenCompose(svc -> svc.get(key))));
    }

    @Override
    public CompletableFuture<Entry> get(ByteArray key, long revUpperBound) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> this.withTrackReadOperationFromLeaderFuture(revUpperBound, () -> this.metaStorageSvcFut.thenCompose(svc -> svc.get(key, revUpperBound))));
    }

    @Override
    public Entry getLocally(ByteArray key) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.get(key.bytes()));
    }

    @Override
    public Entry getLocally(ByteArray key, long revUpperBound) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.get(key.bytes(), revUpperBound));
    }

    @Override
    public Cursor<Entry> getLocally(ByteArray startKey, ByteArray endKey, long revUpperBound) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.range(startKey.bytes(), endKey == null ? null : endKey.bytes(), revUpperBound));
    }

    @Override
    public List<Entry> getAllLocally(List<ByteArray> keys) {
        ArrayList<byte[]> k = new ArrayList<byte[]>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            k.add(keys.get(i).bytes());
        }
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.getAll(k));
    }

    @Override
    public Map<ByteArray, Entry> getAllLocally(Set<ByteArray> keys) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> {
            ArrayList<ByteBuffer> keysList = new ArrayList<ByteBuffer>(keys.size());
            for (ByteArray key : keys) {
                keysList.add(ByteBuffer.wrap(key.bytes()));
            }
            List<Entry> resultEntries = this.storage.getAll(ByteUtils.toByteArrayList(keysList));
            HashMap<ByteArray, Entry> res = IgniteUtils.newHashMap(resultEntries.size());
            for (Entry e : resultEntries) {
                res.put(new ByteArray(e.key()), e);
            }
            return res;
        });
    }

    @Override
    public Cursor<Entry> prefixLocally(ByteArray keyPrefix, long revUpperBound) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> {
            byte[] rangeStart = keyPrefix.bytes();
            byte[] rangeEnd = this.storage.nextKey(rangeStart);
            return this.storage.range(rangeStart, rangeEnd, revUpperBound);
        });
    }

    @Override
    public HybridTimestamp timestampByRevisionLocally(long revision) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.timestampByRevision(revision));
    }

    @Override
    public CompletableFuture<Map<ByteArray, Entry>> getAll(Set<ByteArray> keys) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.withTrackReadOperationFromLeaderFuture(this.storage.revision(), () -> this.metaStorageSvcFut.thenCompose(svc -> svc.getAll(keys))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> put(ByteArray key, byte[] val) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.put(key, val));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> putAll(Map<ByteArray, byte[]> vals) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.putAll(vals));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> remove(ByteArray key) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.remove(key));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> removeAll(Set<ByteArray> keys) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.removeAll(keys));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> removeByPrefix(ByteArray prefix) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.removeByPrefix(prefix));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> invoke(Condition cond, Operation success, Operation failure) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(cond, success, failure));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> invoke(Condition cond, List<Operation> success, List<Operation> failure) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(cond, success, failure));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<StatementResult> invoke(Iif iif) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(iif));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Flow.Publisher<Entry> range(ByteArray keyFrom, @Nullable ByteArray keyTo) {
        if (!this.busyLock.enterBusy()) {
            return new NodeStoppingPublisher<Entry>();
        }
        try {
            Flow.Publisher<Entry> publisher = this.withTrackReadOperationFromLeaderPublisher(this.storage.revision(), () -> new CompletableFuturePublisher(this.metaStorageSvcFut.thenApply(svc -> svc.range(keyFrom, keyTo, false))));
            return publisher;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public Flow.Publisher<Entry> prefix(ByteArray keyPrefix) {
        return this.prefix(keyPrefix, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Flow.Publisher<Entry> prefix(ByteArray keyPrefix, long revUpperBound) {
        if (!this.busyLock.enterBusy()) {
            return new NodeStoppingPublisher<Entry>();
        }
        try {
            Flow.Publisher<Entry> publisher = this.withTrackReadOperationFromLeaderPublisher(revUpperBound, () -> new CompletableFuturePublisher(this.metaStorageSvcFut.thenApply(svc -> svc.prefix(keyPrefix, revUpperBound))));
            return publisher;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void onSafeTimeAdvanced(HybridTimestamp time) {
        assert (time != null);
        if (!this.busyLock.enterBusy()) {
            LOG.info("Skipping advancing Safe Time because the node is stopping", new Object[0]);
            return;
        }
        try {
            this.clusterTime.updateSafeTime(time);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void onRevisionApplied(long revision) {
        this.appliedRevision = revision;
    }

    @Override
    public ClusterTime clusterTime() {
        return this.clusterTime;
    }

    @Override
    public CompletableFuture<Revisions> recoveryFinishedFuture() {
        return this.recoveryFinishedFuture;
    }

    @Override
    public CompletableFuture<IndexWithTerm> raftNodeIndex() {
        return this.raftNodeStarted.thenApply(unused -> IgniteUtils.inBusyLock(this.busyLock, () -> {
            IndexWithTerm indexWithTerm;
            RaftNodeId nodeId = this.raftNodeId();
            try {
                indexWithTerm = this.raftMgr.raftNodeIndex(nodeId);
            }
            catch (NodeStoppingException e) {
                throw new CompletionException(e);
            }
            assert (indexWithTerm != null) : "Attempt to get index and term when Raft node is not started yet or already stopped): " + String.valueOf(nodeId);
            return indexWithTerm;
        }));
    }

    @Override
    public void initiateForcefulVotersChange(long termBeforeChange, Set<String> targetVotingSet) {
        IgniteUtils.inBusyLock(this.busyLock, () -> {
            Object object = this.peersChangeMutex;
            synchronized (object) {
                if (this.peersChangeState != null) {
                    throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Peers change is under way [state=" + String.valueOf(this.peersChangeState) + "].");
                }
                this.peersChangeState = targetVotingSet.size() > 1 ? new PeersChangeState(termBeforeChange, targetVotingSet) : null;
                RaftNodeId raftNodeId = this.raftNodeId();
                PeersAndLearners newConfiguration = PeersAndLearners.fromPeers(Set.of(raftNodeId.peer()), Collections.emptySet());
                ((Loza)this.raftMgr).resetPeers(raftNodeId, newConfiguration);
            }
        });
    }

    private <T> CompletableFuture<T> doWithOneOffRaftGroupService(PeersAndLearners raftClientConfiguration, Function<RaftGroupService, CompletableFuture<T>> action) {
        try {
            RaftGroupService raftGroupService = this.raftMgr.startRaftGroupService(MetastorageGroupId.INSTANCE, raftClientConfiguration, true);
            return action.apply(raftGroupService).whenCompleteAsync((res, ex) -> {
                if (ex != null) {
                    LOG.error("One-off raft group action on {} failed", (Throwable)ex, (Object)raftClientConfiguration);
                }
                raftGroupService.shutdown();
            }, this.ioExecutor);
        }
        catch (NodeStoppingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @TestOnly
    public CompletableFuture<MetaStorageServiceImpl> metaStorageService() {
        return this.metaStorageSvcFut;
    }

    @Override
    public void registerRevisionUpdateListener(RevisionUpdateListener listener) {
        IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.registerRevisionUpdateListener(listener));
    }

    @Override
    public void unregisterRevisionUpdateListener(RevisionUpdateListener listener) {
        IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.unregisterRevisionUpdateListener(listener));
    }

    @Override
    public void registerCompactionRevisionUpdateListener(CompactionRevisionUpdateListener listener) {
        IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.registerCompactionRevisionUpdateListener(listener));
    }

    @Override
    public void unregisterCompactionRevisionUpdateListener(CompactionRevisionUpdateListener listener) {
        IgniteUtils.inBusyLock(this.busyLock, () -> this.storage.unregisterCompactionRevisionUpdateListener(listener));
    }

    public CompletableFuture<Void> notifyRevisionUpdateListenerOnStart() {
        return ((CompletableFuture)this.recoveryFinishedFuture.thenApply(Revisions::revision)).thenCompose(this.storage::notifyRevisionUpdateListenerOnStart);
    }

    public CompletableFuture<Void> evictIdempotentCommandsCache(HybridTimestamp evictionTimestamp) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.evictIdempotentCommandsCache(evictionTimestamp));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    public void disableLearnersAddition() {
        this.learnerManager.disableLearnersAddition();
    }

    @Override
    public long getCompactionRevisionLocally() {
        return IgniteUtils.inBusyLock(this.busyLock, this.storage::getCompactionRevision);
    }

    @TestOnly
    public KeyValueStorage storage() {
        return this.storage;
    }

    private <T> CompletableFuture<T> withTrackReadOperationFromLeaderFuture(long operationRevision, Supplier<CompletableFuture<T>> readFromLeader) {
        ReadOperationForCompactionTracker.TrackingToken token = this.readOperationFromLeaderForCompactionTracker.track(operationRevision, this.storage::revision, this.storage::getCompactionRevision);
        try {
            return readFromLeader.get().whenComplete((t, throwable) -> token.close());
        }
        catch (Throwable t2) {
            token.close();
            throw t2;
        }
    }

    private Flow.Publisher<Entry> withTrackReadOperationFromLeaderPublisher(long operationRevision, Supplier<Flow.Publisher<Entry>> readFromLeader) {
        final ReadOperationForCompactionTracker.TrackingToken token = this.readOperationFromLeaderForCompactionTracker.track(operationRevision, this.storage::revision, this.storage::getCompactionRevision);
        try {
            Flow.Publisher<Entry> publisherFromLeader = readFromLeader.get();
            return subscriber -> publisherFromLeader.subscribe(new Flow.Subscriber<Entry>(){

                @Override
                public void onSubscribe(final Flow.Subscription subscription) {
                    subscriber.onSubscribe(new Flow.Subscription(){

                        @Override
                        public void request(long n) {
                            subscription.request(n);
                        }

                        @Override
                        public void cancel() {
                            token.close();
                            subscription.cancel();
                        }
                    });
                }

                @Override
                public void onNext(Entry item) {
                    subscriber.onNext(item);
                }

                @Override
                public void onError(Throwable throwable) {
                    token.close();
                    subscriber.onError(throwable);
                }

                @Override
                public void onComplete() {
                    token.close();
                    subscriber.onComplete();
                }
            });
        }
        catch (Throwable t) {
            token.close();
            throw t;
        }
    }

    CompletableFuture<Void> sendCompactionCommand(long compactionRevision) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> this.metaStorageSvcFut.thenCompose(svc -> svc.sendCompactionCommand(compactionRevision)));
    }

    private static class PeersChangeState {
        private final long termBeforeChange;
        private final Set<String> targetPeers;

        private PeersChangeState(long termBeforeChange, Set<String> targetPeers) {
            this.termBeforeChange = termBeforeChange;
            this.targetPeers = Set.copyOf(targetPeers);
        }

        public String toString() {
            return S.toString(this);
        }
    }

    private static class NodeStoppingPublisher<T>
    implements Flow.Publisher<T> {
        private NodeStoppingPublisher() {
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            subscriber.onError(new NodeStoppingException());
        }
    }

    private static class CompletableFuturePublisher<T>
    implements Flow.Publisher<T> {
        private final CompletableFuture<Flow.Publisher<T>> future;

        CompletableFuturePublisher(CompletableFuture<Flow.Publisher<T>> future) {
            this.future = future;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            this.future.whenComplete((publisher, e) -> {
                if (e != null) {
                    subscriber.onError((Throwable)e);
                } else {
                    publisher.subscribe(subscriber);
                }
            });
        }
    }

    private static class MetaStorageInfoAndClusterState {
        private final MetaStorageInfo metaStorageInfo;
        private final ClusterState clusterState;

        private MetaStorageInfoAndClusterState(MetaStorageInfo metaStorageInfo, ClusterState clusterState) {
            this.metaStorageInfo = metaStorageInfo;
            this.clusterState = clusterState;
        }
    }
}

