/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.server.Value;
import org.jetbrains.annotations.Nullable;

public final class EntryImpl
implements Entry {
    private static final long serialVersionUID = 3636551347117181271L;
    private final byte[] key;
    private final byte @Nullable [] value;
    private final long revision;
    @Nullable
    private final HybridTimestamp timestamp;

    public EntryImpl(byte[] key, byte @Nullable [] value, long revision, @Nullable HybridTimestamp timestamp) {
        this.key = key;
        this.value = value;
        this.revision = revision;
        this.timestamp = timestamp;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte @Nullable [] value() {
        return this.value;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    @Override
    @Nullable
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean tombstone() {
        return this.value == null && this.timestamp != null;
    }

    public static Entry tombstone(byte[] key, long revision, HybridTimestamp timestamp) {
        return new EntryImpl(key, null, revision, timestamp);
    }

    @Override
    public boolean empty() {
        return this.timestamp == null;
    }

    public static Entry empty(byte[] key) {
        return new EntryImpl(key, null, 0L, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryImpl entry = (EntryImpl)o;
        if (this.revision != entry.revision) {
            return false;
        }
        if (!Objects.equals(this.timestamp, entry.timestamp)) {
            return false;
        }
        if (!Arrays.equals(this.key, entry.key)) {
            return false;
        }
        return Arrays.equals(this.value, entry.value);
    }

    public int hashCode() {
        int res = Arrays.hashCode(this.key);
        res = 31 * res + Arrays.hashCode(this.value);
        res = 31 * res + (int)(this.revision ^ this.revision >>> 32);
        res = 31 * res + Objects.hashCode(this.timestamp);
        return res;
    }

    public String toString() {
        return "EntryImpl{key=" + new String(this.key, StandardCharsets.UTF_8) + ", value=" + Arrays.toString(this.value) + ", revision=" + this.revision + ", timestamp=" + String.valueOf(this.timestamp) + "}";
    }

    public static Entry toEntry(byte[] key, long revision, Value value) {
        if (value.tombstone()) {
            return EntryImpl.tombstone(key, revision, value.operationTimestamp());
        }
        return new EntryImpl(key, value.bytes(), revision, value.operationTimestamp());
    }
}

