/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.exception;

import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.DeploymentStatus;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;

public class DeploymentUnitUnavailableException
extends IgniteException {
    private final String id;
    private final Version version;
    private final DeploymentStatus clusterStatus;
    private final DeploymentStatus nodeStatus;

    public DeploymentUnitUnavailableException(String id, Version version, DeploymentStatus clusterStatus, DeploymentStatus nodeStatus) {
        super(ErrorGroups.CodeDeployment.UNIT_UNAVAILABLE_ERR, DeploymentUnitUnavailableException.message(id, version, clusterStatus, nodeStatus));
        this.id = id;
        this.version = version;
        this.clusterStatus = clusterStatus;
        this.nodeStatus = nodeStatus;
    }

    public String id() {
        return this.id;
    }

    public Version version() {
        return this.version;
    }

    public DeploymentStatus clusterStatus() {
        return this.clusterStatus;
    }

    public DeploymentStatus nodeStatus() {
        return this.nodeStatus;
    }

    private static String message(String id, Version version, DeploymentStatus clusterStatus, DeploymentStatus nodeStatus) {
        return "Unit " + id + ":" + String.valueOf(version) + " is unavailable. Cluster status: " + String.valueOf((Object)clusterStatus) + ", node status: " + String.valueOf((Object)nodeStatus);
    }
}

