/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.configuration.SystemLocalExtensionChange;
import org.apache.ignite3.internal.configuration.SystemLocalExtensionConfiguration;
import org.apache.ignite3.internal.configuration.SystemLocalExtensionConfigurationSchema;
import org.apache.ignite3.internal.configuration.SystemLocalExtensionView;
import org.apache.ignite3.internal.configuration.ThreadPoolsExtensionConfigurationSchema;
import org.apache.ignite3.internal.worker.configuration.CriticalWorkersChange;
import org.apache.ignite3.internal.worker.configuration.CriticalWorkersView;

@AutoService(value={ConfigurationModule.class})
public class SystemLocalConfigurationModule
implements ConfigurationModule {
    @Override
    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return List.of(SystemLocalExtensionConfigurationSchema.class, ThreadPoolsExtensionConfigurationSchema.class);
    }

    @Override
    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        SystemLocalExtensionView rootView = superRootChange.viewRoot(SystemLocalExtensionConfiguration.KEY);
        SystemLocalExtensionChange rootChange = superRootChange.changeRoot(SystemLocalExtensionConfiguration.KEY);
        CriticalWorkersView criticalWorkersView = rootView.criticalWorkers();
        CriticalWorkersChange criticalWorkersChange = rootChange.changeSystem().changeCriticalWorkers();
        if (criticalWorkersView.livenessCheckIntervalMillis() != 2000L) {
            criticalWorkersChange.changeLivenessCheckIntervalMillis(criticalWorkersView.livenessCheckIntervalMillis());
        }
        if (criticalWorkersView.maxAllowedLagMillis() != 5000L) {
            criticalWorkersChange.changeMaxAllowedLagMillis(criticalWorkersView.maxAllowedLagMillis());
        }
        if (criticalWorkersView.nettyThreadsHeartbeatIntervalMillis() != 1000L) {
            criticalWorkersChange.changeNettyThreadsHeartbeatIntervalMillis(criticalWorkersView.nettyThreadsHeartbeatIntervalMillis());
        }
    }
}

