/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.table.QualifiedName;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;

class AbstractSecuredTableView {
    protected final Authorizer authorizer;
    protected final SecurityContext context;
    private final QualifiedName name;
    private volatile Privilege select;
    private volatile Privilege insert;
    private volatile Privilege update;
    private volatile Privilege delete;
    private volatile Set<Privilege> upsert;
    private volatile Set<Privilege> replace;
    private volatile Set<Privilege> getAndDelete;

    AbstractSecuredTableView(Authorizer authorizer, SecurityContext context, QualifiedName name) {
        this.authorizer = authorizer;
        this.context = context;
        this.name = name;
    }

    protected <T> T sync(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteExceptionMapperUtil.mapToPublicException(e));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.unwrapCause(e));
        }
    }

    protected Privilege selectPrivilege() {
        if (this.select == null) {
            this.select = this.getPrivilege(Action.SELECT_FROM_TABLE);
        }
        return this.select;
    }

    protected Privilege insertPrivilege() {
        if (this.insert == null) {
            this.insert = this.getPrivilege(Action.INSERT_INTO_TABLE);
        }
        return this.insert;
    }

    private Privilege updatePrivilege() {
        if (this.update == null) {
            this.update = this.getPrivilege(Action.UPDATE_TABLE);
        }
        return this.update;
    }

    protected Privilege deletePrivilege() {
        if (this.delete == null) {
            this.delete = this.getPrivilege(Action.DELETE_FROM_TABLE);
        }
        return this.delete;
    }

    protected Set<Privilege> upsertPrivilege() {
        if (this.upsert == null) {
            this.upsert = Set.of(this.selectPrivilege(), this.insertPrivilege(), this.updatePrivilege());
        }
        return this.upsert;
    }

    protected Set<Privilege> replacePrivilege() {
        if (this.replace == null) {
            this.replace = Set.of(this.selectPrivilege(), this.updatePrivilege());
        }
        return this.replace;
    }

    protected Set<Privilege> getAndDeletePrivilege() {
        if (this.getAndDelete == null) {
            this.getAndDelete = Set.of(this.selectPrivilege(), this.deletePrivilege());
        }
        return this.getAndDelete;
    }

    private Privilege getPrivilege(Action action) {
        return Privilege.builder().action(action).selector(Selector.table(this.name.schemaName(), this.name.objectName())).build();
    }
}

