/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.compute.BroadcastExecution;
import org.apache.ignite3.compute.BroadcastJobTarget;
import org.apache.ignite3.compute.IgniteCompute;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobTarget;
import org.apache.ignite3.compute.TaskDescriptor;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.compute.AntiHijackBroadcastExecution;
import org.apache.ignite3.internal.compute.AntiHijackJobExecution;
import org.apache.ignite3.internal.compute.task.AntiHijackTaskExecution;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.CancellationToken;
import org.jetbrains.annotations.Nullable;

public class AntiHijackIgniteCompute
implements IgniteCompute,
Wrapper {
    private final IgniteCompute compute;
    private final Executor asyncContinuationExecutor;

    public AntiHijackIgniteCompute(IgniteCompute compute, Executor asyncContinuationExecutor) {
        this.compute = compute;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.preventThreadHijack((CompletableFuture<T>)this.compute.submitAsync(target, descriptor, arg, cancellationToken).thenApply(this::preventThreadHijack));
    }

    @Override
    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.preventThreadHijack((CompletableFuture<T>)this.compute.submitAsync(target, descriptor, arg, cancellationToken).thenApply(this::preventThreadHijack));
    }

    @Override
    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    @Override
    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    @Override
    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return new AntiHijackTaskExecution<R>(this.compute.submitMapReduce(taskDescriptor, arg, cancellationToken), this.asyncContinuationExecutor);
    }

    @Override
    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.executeMapReduce(taskDescriptor, arg, cancellationToken);
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }

    private <T, R> JobExecution<R> preventThreadHijack(JobExecution<R> execution) {
        return new AntiHijackJobExecution<R>(execution, this.asyncContinuationExecutor);
    }

    private <T, R> BroadcastExecution<R> preventThreadHijack(BroadcastExecution<R> execution) {
        return new AntiHijackBroadcastExecution<R>(execution, this.asyncContinuationExecutor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.compute, classToUnwrap);
    }
}

