/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.cluster.unit;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cli.call.cluster.unit.DeployUnitCallInput;
import org.apache.ignite3.internal.cli.commands.cluster.unit.NodesAlias;
import picocli.CommandLine;

class UnitDeployOptionsMixin {
    @CommandLine.Parameters(index="0")
    private String id;
    @CommandLine.Option(names={"--version"}, description={"Unit version (x.y.z)"}, required=true)
    private String version;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private Path path;
    private List<String> nodes;

    UnitDeployOptionsMixin() {
    }

    @CommandLine.Option(names={"--path"}, description={"Path to deployment unit file or directory"}, required=true)
    private void setPath(Path value) {
        if (Files.notExists(value, new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No such file or directory: " + String.valueOf(value));
        }
        this.path = value;
    }

    @CommandLine.Option(names={"--nodes"}, description={"Initial set of nodes where the unit will be deployed"}, split=",")
    private void setNodes(List<String> values) {
        if (values.size() > 1) {
            ArrayList aliases = new ArrayList();
            ArrayList nodeNames = new ArrayList();
            values.forEach(it -> {
                String trimmed = it.trim();
                NodesAlias alias = NodesAlias.parse(trimmed);
                if (alias != null) {
                    aliases.add(alias);
                } else {
                    nodeNames.add(trimmed);
                }
            });
            if (aliases.size() > 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Aliases " + String.valueOf(aliases) + " can not be specified together. Provide single alias, please.");
            }
            if (aliases.size() == 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Alias " + String.valueOf(aliases.get(0)) + " couldn't be used with explicit nodes names list " + String.valueOf(nodeNames) + ". Provide either node names list or single alias.");
            }
        }
        this.nodes = values;
    }

    DeployUnitCallInput toDeployUnitCallInput(String url) {
        return DeployUnitCallInput.builder().id(this.id).version(this.version).path(this.path).nodes(this.nodes).clusterUrl(url).build();
    }
}

