/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.Arrays;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite3.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class RemoveIndexEntry
implements UpdateEntry,
Fireable {
    private final int indexId;

    public RemoveIndexEntry(int indexId) {
        this.indexId = indexId;
    }

    public int indexId() {
        return this.indexId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.REMOVE_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_REMOVED;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new RemoveIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSchemaDescriptor schema = AbstractChangeIndexStatusEntry.schemaByIndexId(catalog, this.indexId);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), (CatalogIndexDescriptor[])Arrays.stream(schema.indexes()).filter(t -> t.id() != this.indexId).toArray(CatalogIndexDescriptor[]::new), schema.systemViews(), schema.sequences(), schema.policies(), schema.maps(), timestamp), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString(this);
    }
}

