/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.sql.ColumnType;

public class CatalogTableColumnDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class TableColumnDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogTableColumnDescriptor> {
        TableColumnDescriptorSerializerV2() {
        }

        @Override
        public CatalogTableColumnDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            String name = input.readUTF();
            int typeId = input.readVarIntAsInt();
            ColumnType type = ColumnType.getById(typeId);
            assert (type != null) : "Unknown column type: " + typeId;
            boolean nullable = input.readBoolean();
            int precision = input.readVarIntAsInt();
            int scale = input.readVarIntAsInt();
            int length = input.readVarIntAsInt();
            DefaultValue defaultValue = DefaultValue.readFrom(input);
            return new CatalogTableColumnDescriptor(name, type, nullable, precision, scale, length, defaultValue);
        }

        @Override
        public void writeTo(CatalogTableColumnDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.type().id());
            output.writeBoolean(descriptor.nullable());
            output.writeVarInt(descriptor.precision());
            output.writeVarInt(descriptor.scale());
            output.writeVarInt(descriptor.length());
            DefaultValue.writeTo(descriptor.defaultValue(), output);
        }
    }
}

