/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.JdbcHandlerBase;
import org.apache.ignite3.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcFetchQueryResultsRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcQueryCloseRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcQueryCloseResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcQueryFetchResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;

public class JdbcQueryCursorHandlerImpl
extends JdbcHandlerBase
implements JdbcQueryCursorHandler {
    JdbcQueryCursorHandlerImpl(ClientResourceRegistry resources) {
        super(resources);
    }

    @Override
    public CompletableFuture<JdbcQueryFetchResult> fetchAsync(JdbcFetchQueryResultsRequest req) {
        AsyncSqlCursor asyncSqlCursor;
        try {
            asyncSqlCursor = this.resources.get(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcQueryFetchResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + String.valueOf(sw)));
        }
        if (req.fetchSize() <= 0) {
            return CompletableFuture.completedFuture(new JdbcQueryFetchResult(1, "Invalid fetch size [fetchSize=" + req.fetchSize() + "]"));
        }
        return ((CompletableFuture)asyncSqlCursor.requestNextAsync(req.fetchSize()).handle((batch, t) -> {
            if (t != null) {
                StringWriter sw = this.getWriterWithStackTrace((Throwable)t);
                return new JdbcQueryFetchResult(1, "Failed to fetch query results [curId=" + req.cursorId() + "]. Error message: " + String.valueOf(sw));
            }
            ArrayList<ByteBuffer> rows = new ArrayList<ByteBuffer>(batch.items().size());
            for (InternalSqlRow item : batch.items()) {
                rows.add(item.asBinaryTuple().byteBuffer());
            }
            return new JdbcQueryFetchResult(rows, !batch.hasMore());
        })).toCompletableFuture();
    }

    @Override
    public CompletableFuture<JdbcQuerySingleResult> getMoreResultsAsync(JdbcFetchQueryResultsRequest req) {
        AsyncSqlCursor asyncSqlCursor;
        try {
            asyncSqlCursor = this.resources.remove(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcQuerySingleResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + String.valueOf(sw)));
        }
        CompletableFuture<Void> cursorCloseFuture = asyncSqlCursor.closeAsync();
        if (!asyncSqlCursor.hasNextResult()) {
            return CompletableFuture.completedFuture(new JdbcQuerySingleResult(1, "Cursor doesn't have next result"));
        }
        return ((CompletableFuture)((CompletableFuture)cursorCloseFuture.thenCompose(c -> asyncSqlCursor.nextResult())).thenCompose(cur -> this.createJdbcResult((AsyncSqlCursor<InternalSqlRow>)cur, req.fetchSize()))).exceptionally(t -> {
            JdbcQueryCursorHandlerImpl.iterateThroughResultsAndCloseThem(asyncSqlCursor);
            String msgPrefix = "Failed to fetch query results [curId=" + req.cursorId() + "].";
            return this.createErrorResult(msgPrefix, (Throwable)t, msgPrefix + " Error message: ");
        });
    }

    private static void iterateThroughResultsAndCloseThem(AsyncSqlCursor<InternalSqlRow> cursor) {
        Function<AsyncSqlCursor<InternalSqlRow>, CompletableFuture<AsyncSqlCursor<InternalSqlRow>>> traverser = new Function<AsyncSqlCursor<InternalSqlRow>, CompletableFuture<AsyncSqlCursor<InternalSqlRow>>>(){

            @Override
            public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> apply(AsyncSqlCursor<InternalSqlRow> cur) {
                return cur.closeAsync().thenCompose(none -> {
                    if (cur.hasNextResult()) {
                        return cur.nextResult().thenCompose((Function)this);
                    }
                    return CompletableFuture.completedFuture(cur);
                });
            }
        };
        CompletableFuture.completedFuture(cursor).thenCompose(traverser);
    }

    @Override
    public CompletableFuture<JdbcQueryCloseResult> closeAsync(JdbcQueryCloseRequest req) {
        AsyncSqlCursor asyncSqlCursor;
        try {
            asyncSqlCursor = req.removeFromResources() ? this.resources.remove(req.cursorId()).get(AsyncSqlCursor.class) : this.resources.get(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcQueryCloseResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + String.valueOf(sw)));
        }
        return asyncSqlCursor.closeAsync().handle((none, t) -> {
            if (t != null) {
                StringWriter sw = this.getWriterWithStackTrace((Throwable)t);
                return new JdbcQueryCloseResult(1, "Failed to close SQL query cursor [curId=" + req.cursorId() + "]. Error message: " + String.valueOf(sw));
            }
            return new JdbcQueryCloseResult();
        });
    }

    private StringWriter getWriterWithStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw;
    }
}

