/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.apache.ignite3.client.handler.ClientContext;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.client.handler.ClientPrimaryReplicaTracker;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.ClusterInfo;
import org.apache.ignite3.client.handler.JdbcQueryCursorHandlerImpl;
import org.apache.ignite3.client.handler.JdbcQueryEventHandlerImpl;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.configuration.ClientConnectorView;
import org.apache.ignite3.client.handler.requests.ClientOperationCancelRequest;
import org.apache.ignite3.client.handler.requests.cache.ClientCacheGetQualifiedRequest;
import org.apache.ignite3.client.handler.requests.cache.ClientCacheGetRequest;
import org.apache.ignite3.client.handler.requests.cache.ClientCachesGetQualifiedRequest;
import org.apache.ignite3.client.handler.requests.cache.ClientCachesGetRequest;
import org.apache.ignite3.client.handler.requests.cluster.ClientClusterGetNodesRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeCancelRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeChangePriorityRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecuteColocatedRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecuteMapReduceRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecutePartitionedRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcCancelRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcCloseRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcColumnMetadataRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcConnectRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcExecuteBatchRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcExecuteRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcFetchRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcFinishTxRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcHasMoreRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcPreparedStmntBatchRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcPrimaryKeyMetadataRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcSchemasMetadataRequest;
import org.apache.ignite3.client.handler.requests.jdbc.ClientJdbcTableMetadataRequest;
import org.apache.ignite3.client.handler.requests.jdbc.JdbcMetadataCatalog;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlCursorCloseRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlCursorNextPageRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlExecuteBatchRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlExecuteRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlExecuteScriptRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlQueryMetadataRequest;
import org.apache.ignite3.client.handler.requests.structure.ClientGetOrCreateMapRequest;
import org.apache.ignite3.client.handler.requests.table.ClientContinuousQueryScanRequest;
import org.apache.ignite3.client.handler.requests.table.ClientSchemasGetRequest;
import org.apache.ignite3.client.handler.requests.table.ClientStreamerBatchSendRequest;
import org.apache.ignite3.client.handler.requests.table.ClientStreamerWithReceiverBatchSendRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTableGetQualifiedRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTableGetRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTablePartitionPrimaryReplicasGetRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTablesGetQualifiedRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTablesGetRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleContainsAllKeysRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleContainsKeyRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleDeleteAllExactRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleDeleteAllRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleDeleteExactRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleDeleteRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleGetAllRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleGetAndDeleteRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleGetAndReplaceRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleGetAndUpsertRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleGetRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleInsertAllRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleInsertRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleReplaceExactRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleReplaceRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleUpsertAllRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTupleUpsertRequest;
import org.apache.ignite3.client.handler.requests.table.partition.ClientTablePartitionPrimaryReplicasNodesGetRequest;
import org.apache.ignite3.client.handler.requests.tx.ClientTransactionBeginRequest;
import org.apache.ignite3.client.handler.requests.tx.ClientTransactionCommitRequest;
import org.apache.ignite3.client.handler.requests.tx.ClientTransactionRollbackRequest;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.deployment.DeploymentUnitInfo;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessageCommon;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.ClientOp;
import org.apache.ignite3.internal.client.proto.HandshakeExtension;
import org.apache.ignite3.internal.client.proto.HandshakeUtils;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.client.proto.ProtocolVersion;
import org.apache.ignite3.internal.client.proto.ResponseFlags;
import org.apache.ignite3.internal.client.proto.ServerOpResponseFlags;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.executor.platform.PlatformComputeConnection;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.IgniteClusterImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.handshake.HandshakeEventLoopSwitcher;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.schema.SchemaVersionMismatchException;
import org.apache.ignite3.internal.security.authentication.AnonymousRequest;
import org.apache.ignite3.internal.security.authentication.AuthenticationManager;
import org.apache.ignite3.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.apache.ignite3.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationEvent;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationProviderEventParameters;
import org.apache.ignite3.internal.security.authentication.event.UserEventParameters;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.CancelHandle;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.network.IgniteCluster;
import org.apache.ignite3.security.AuthenticationType;
import org.apache.ignite3.security.exception.UnsupportedAuthenticationTypeException;
import org.apache.ignite3.sql.SqlBatchException;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.structure.IgniteStructures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientInboundMessageHandler
extends ChannelInboundHandlerAdapter
implements EventListener<AuthenticationEventParameters> {
    private static final IgniteLogger LOG = Loggers.forClass(ClientInboundMessageHandler.class);
    private static final byte STATE_BEFORE_HANDSHAKE = 0;
    private static final byte STATE_HANDSHAKE_REQUESTED = 1;
    private static final byte STATE_HANDSHAKE_RESPONSE_SENT = 2;
    private final IgniteTablesInternal igniteTables;
    private final TxManager txManager;
    private final JdbcQueryEventHandlerImpl jdbcQueryEventHandler;
    private final ClientResourceRegistry resources = new ClientResourceRegistry();
    private final ClientConnectorView configuration;
    private final IgniteComputeInternal compute;
    private final ClusterService clusterService;
    private final IgniteCluster cluster;
    private final QueryProcessor queryProcessor;
    private final JdbcQueryCursorHandler jdbcQueryCursorHandler;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final ClientHandlerMetricSource metrics;
    private final ClockService clockService;
    private final CatalogService catalogService;
    private ClientContext clientContext;
    private byte state = 0;
    private volatile ChannelHandlerContext channelHandlerContext;
    private final AtomicLong primaryReplicaMaxStartTime;
    private final ClientPrimaryReplicaTracker primaryReplicaTracker;
    private final AuthenticationManager authenticationManager;
    private final SchemaVersions schemaVersions;
    private final long connectionId;
    private final Executor partitionOperationsExecutor;
    private final BitSet features;
    private final Map<HandshakeExtension, Object> extensions;
    private final Map<Long, CancelHandle> cancelHandles = new ConcurrentHashMap<Long, CancelHandle>();
    private final Function<String, CompletableFuture<PlatformComputeConnection>> computeConnectionFunc;
    private final AtomicLong serverToClientRequestId = new AtomicLong(-1L);
    private final Map<Long, CompletableFuture<ClientMessageUnpacker>> serverToClientRequests = new ConcurrentHashMap<Long, CompletableFuture<ClientMessageUnpacker>>();
    private final IgniteStructures structures;
    private final HandshakeEventLoopSwitcher handshakeEventLoopSwitcher;

    public ClientInboundMessageHandler(IgniteTablesInternal igniteTables, TxManager txManager, QueryProcessor processor, ClientConnectorView configuration, IgniteComputeInternal compute, ClusterService clusterService, Supplier<ClusterInfo> clusterInfoSupplier, ClientHandlerMetricSource metrics, AuthenticationManager authenticationManager, ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService, long connectionId, ClientPrimaryReplicaTracker primaryReplicaTracker, Executor partitionOperationsExecutor, BitSet features, Map<HandshakeExtension, Object> extensions, Authorizer authorizer, Function<String, CompletableFuture<PlatformComputeConnection>> computeConnectionFunc, IgniteStructures structures, HandshakeEventLoopSwitcher handshakeEventLoopSwitcher) {
        assert (igniteTables != null);
        assert (txManager != null);
        assert (processor != null);
        assert (configuration != null);
        assert (compute != null);
        assert (clusterService != null);
        assert (clusterInfoSupplier != null);
        assert (metrics != null);
        assert (authenticationManager != null);
        assert (clockService != null);
        assert (schemaSyncService != null);
        assert (catalogService != null);
        assert (primaryReplicaTracker != null);
        assert (partitionOperationsExecutor != null);
        assert (features != null);
        assert (extensions != null);
        assert (authorizer != null);
        this.igniteTables = igniteTables;
        this.txManager = txManager;
        this.configuration = configuration;
        this.compute = compute;
        this.clusterService = clusterService;
        this.cluster = new IgniteClusterImpl(clusterService.topologyService(), () -> {
            ClusterInfo clusterInfo = (ClusterInfo)clusterInfoSupplier.get();
            List<UUID> idHistory = clusterInfo.idHistory();
            return idHistory.isEmpty() ? null : idHistory.get(idHistory.size() - 1);
        });
        this.queryProcessor = processor;
        this.clusterInfoSupplier = clusterInfoSupplier;
        this.metrics = metrics;
        this.authenticationManager = authenticationManager;
        this.clockService = clockService;
        this.catalogService = catalogService;
        this.primaryReplicaTracker = primaryReplicaTracker;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.handshakeEventLoopSwitcher = handshakeEventLoopSwitcher;
        this.jdbcQueryCursorHandler = new JdbcQueryCursorHandlerImpl(this.resources);
        this.jdbcQueryEventHandler = new JdbcQueryEventHandlerImpl(processor, new JdbcMetadataCatalog(clockService, schemaSyncService, catalogService), this.resources, txManager, authorizer);
        this.schemaVersions = new SchemaVersionsImpl(schemaSyncService, catalogService, clockService);
        this.connectionId = connectionId;
        this.primaryReplicaMaxStartTime = new AtomicLong(HybridTimestamp.MIN_VALUE.longValue());
        this.features = features;
        this.extensions = extensions;
        this.computeConnectionFunc = computeConnectionFunc;
        this.structures = structures;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ClientInboundMessageHandler.authenticationEventsToSubscribe().forEach(event -> this.authenticationManager.listen(event, this));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        ClientInboundMessageHandler.authenticationEventsToSubscribe().forEach(event -> this.authenticationManager.removeListener(event, this));
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.channelHandlerContext = ctx;
        super.channelRegistered(ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection registered [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf byteBuf = (ByteBuf)msg;
        ClientMessageUnpacker unpacker = new ClientMessageUnpacker(byteBuf);
        this.metrics.bytesReceivedAdd(byteBuf.readableBytes() + 4);
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.metrics.bytesReceivedAdd(ClientMessageCommon.MAGIC_BYTES.length);
                this.handshake(ctx, unpacker);
                break;
            }
            case 1: {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected message received before handshake completion");
            }
            case 2: {
                assert (this.clientContext != null) : "Client context != null";
                String username = this.clientContext.userDetails().username();
                Set<String> roles = this.clientContext.userDetails().roles();
                SecurityContext context = GridGainSecurity.context(username, roles);
                this.processOperation(ctx, unpacker, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + this.state);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.resources.close();
        for (CompletableFuture<ClientMessageUnpacker> fut : this.serverToClientRequests.values()) {
            fut.completeExceptionally(new IgniteException(ErrorGroups.Client.SERVER_TO_CLIENT_REQUEST_ERR, "Connection lost"));
        }
        super.channelInactive(ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection closed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
    }

    private void handshake(ChannelHandlerContext ctx, ClientMessageUnpacker unpacker) {
        try (ClientMessageUnpacker clientMessageUnpacker = unpacker;){
            ProtocolVersion clientVer = ProtocolVersion.unpack(unpacker);
            if (!clientVer.equals(ProtocolVersion.LATEST_VER)) {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_COMPATIBILITY_ERR, "Unsupported version: " + clientVer.major() + "." + clientVer.minor() + "." + clientVer.patch());
            }
            int clientCode = unpacker.unpackInt();
            BitSet clientFeatures = HandshakeUtils.unpackFeatures(unpacker);
            Map<HandshakeExtension, Object> clientHandshakeExtensions = HandshakeUtils.unpackExtensions(unpacker);
            String computeExecutorId = (String)clientHandshakeExtensions.get((Object)HandshakeExtension.COMPUTE_EXECUTOR_ID);
            if (computeExecutorId != null) {
                CompletableFuture<PlatformComputeConnection> computeConnFut = this.computeConnectionFunc.apply(computeExecutorId);
                if (computeConnFut == null) {
                    String msg = "Invalid compute executor ID, client connection rejected [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + ", executorId=" + computeExecutorId + "]";
                    LOG.debug(msg, new Object[0]);
                    this.handshakeError(ctx, new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, msg));
                } else {
                    LOG.debug("Compute executor connected [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + ", executorId=" + computeExecutorId + "]", new Object[0]);
                    this.handshakeSuccess(ctx, UserDetails.UNKNOWN, clientFeatures, clientVer, clientCode);
                    computeConnFut.complete(new ComputeConnection());
                }
                return;
            }
            AuthenticationRequest<?, ?> authReq = ClientInboundMessageHandler.createAuthenticationRequest(clientHandshakeExtensions);
            ((CompletableFuture)this.handshakeEventLoopSwitcher.switchEventLoopIfNeeded(this.channelHandlerContext.channel()).thenCompose(unused -> this.authenticationManager.authenticateAsync(authReq))).whenCompleteAsync((user, err) -> {
                if (err != null) {
                    this.handshakeError(ctx, (Throwable)err);
                } else {
                    this.handshakeSuccess(ctx, (UserDetails)user, clientFeatures, clientVer, clientCode);
                }
            }, (Executor)ctx.executor());
        }
        catch (Throwable t) {
            this.handshakeError(ctx, t);
        }
    }

    private void handshakeSuccess(ChannelHandlerContext ctx, UserDetails user, BitSet clientFeatures, ProtocolVersion clientVer, int clientCode) {
        BitSet actualFeatures;
        boolean supportsDirectMapping;
        boolean bl = supportsDirectMapping = this.features.get(ProtocolBitmaskFeature.TX_DIRECT_MAPPING.featureId()) && clientFeatures.get(ProtocolBitmaskFeature.TX_DIRECT_MAPPING.featureId()) && this.features.get(ProtocolBitmaskFeature.TX_DELAYED_ACKS.featureId()) && clientFeatures.get(ProtocolBitmaskFeature.TX_DELAYED_ACKS.featureId()) && this.features.get(ProtocolBitmaskFeature.TX_PIGGYBACK.featureId()) && clientFeatures.get(ProtocolBitmaskFeature.TX_PIGGYBACK.featureId()) && this.features.get(ProtocolBitmaskFeature.TX_ALLOW_NOOP_ENLIST.featureId()) && clientFeatures.get(ProtocolBitmaskFeature.TX_ALLOW_NOOP_ENLIST.featureId());
        if (!supportsDirectMapping) {
            actualFeatures = (BitSet)this.features.clone();
            actualFeatures.clear(ProtocolBitmaskFeature.TX_DIRECT_MAPPING.featureId());
            actualFeatures.clear(ProtocolBitmaskFeature.TX_DELAYED_ACKS.featureId());
            actualFeatures.clear(ProtocolBitmaskFeature.TX_PIGGYBACK.featureId());
            actualFeatures.clear(ProtocolBitmaskFeature.TX_ALLOW_NOOP_ENLIST.featureId());
            actualFeatures.clear(ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING.featureId());
        } else {
            actualFeatures = this.features;
        }
        BitSet supportedFeatures = HandshakeUtils.supportedFeatures(actualFeatures, clientFeatures);
        this.clientContext = new ClientContext(clientVer, clientCode, supportedFeatures, user, ctx.channel().remoteAddress());
        this.sendHandshakeResponse(ctx, actualFeatures);
    }

    private void handshakeError(ChannelHandlerContext ctx, Throwable t) {
        LOG.warn("Handshake failed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + t.getMessage(), t);
        ClientMessagePacker errPacker = ClientInboundMessageHandler.getPacker(ctx.alloc());
        try {
            ProtocolVersion.LATEST_VER.pack(errPacker);
            this.writeErrorCore(t, errPacker);
            this.writeAndFlushWithMagic(errPacker, ctx);
        }
        catch (Throwable t2) {
            LOG.warn("Handshake failed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + t2.getMessage(), t2);
            errPacker.close();
            this.exceptionCaught(ctx, t2);
        }
        this.metrics.sessionsRejectedIncrement();
    }

    private void sendHandshakeResponse(ChannelHandlerContext ctx, BitSet mutuallySupportedFeatures) {
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(ctx.alloc());
        try {
            this.writeHandshakeResponse(mutuallySupportedFeatures, packer);
            this.writeAndFlushWithMagic(packer, ctx);
        }
        catch (Throwable t) {
            packer.close();
            throw t;
        }
        this.state = (byte)2;
        this.metrics.sessionsAcceptedIncrement();
        this.metrics.sessionsActiveIncrement();
        ctx.channel().closeFuture().addListener(f -> this.metrics.sessionsActiveDecrement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handshake [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + String.valueOf(this.clientContext), new Object[0]);
        }
    }

    private void writeHandshakeResponse(BitSet mutuallySupportedFeatures, ClientMessagePacker packer) {
        ProtocolVersion.LATEST_VER.pack(packer);
        packer.packNil();
        packer.packLong(this.configuration.idleTimeoutMillis());
        InternalClusterNode localMember = this.clusterService.topologyService().localMember();
        packer.packUuid(localMember.id());
        packer.packString(localMember.name());
        ClusterInfo clusterInfo = this.clusterInfoSupplier.get();
        packer.packInt(clusterInfo.idHistory().size());
        for (UUID clusterId : clusterInfo.idHistory()) {
            packer.packUuid(clusterId);
        }
        packer.packString(clusterInfo.name());
        packer.packLong(this.clockService.currentLong());
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.major());
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.minor());
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.maintenance());
        packer.packByteNullable(IgniteProductVersion.CURRENT_VERSION.patch());
        packer.packStringNullable(IgniteProductVersion.CURRENT_VERSION.preRelease());
        HandshakeUtils.packFeatures(packer, mutuallySupportedFeatures);
        HandshakeUtils.packExtensions(packer, this.extensions);
    }

    private static AuthenticationRequest<?, ?> createAuthenticationRequest(Map<HandshakeExtension, Object> extensions) {
        Object authnType = extensions.get((Object)HandshakeExtension.AUTHENTICATION_TYPE);
        if (authnType == null) {
            return new AnonymousRequest();
        }
        if (authnType instanceof String && AuthenticationType.BASIC.name().equalsIgnoreCase((String)authnType)) {
            return new UsernamePasswordRequest((String)extensions.get((Object)HandshakeExtension.AUTHENTICATION_IDENTITY), (String)extensions.get((Object)HandshakeExtension.AUTHENTICATION_SECRET));
        }
        throw new UnsupportedAuthenticationTypeException("Unsupported authentication type: " + String.valueOf(authnType));
    }

    private void writeAndFlush(ClientMessagePacker packer, ChannelHandlerContext ctx) {
        ByteBuf buf = packer.getBuffer();
        int bytes = buf.readableBytes();
        try {
            ctx.writeAndFlush((Object)buf);
        }
        catch (Throwable t) {
            packer.close();
            throw t;
        }
        this.metrics.bytesSentAdd(bytes);
    }

    private void writeAndFlushWithMagic(ClientMessagePacker packer, ChannelHandlerContext ctx) {
        ctx.write((Object)Unpooled.wrappedBuffer((byte[])ClientMessageCommon.MAGIC_BYTES));
        this.writeAndFlush(packer, ctx);
        this.metrics.bytesSentAdd(ClientMessageCommon.MAGIC_BYTES.length);
    }

    private void writeResponseHeader(ClientMessagePacker packer, long requestId, ChannelHandlerContext ctx, boolean isNotification, boolean isError, long timestamp) {
        packer.packLong(requestId);
        this.writeFlags(packer, ctx, isNotification, isError);
        packer.packLong(Math.max(this.clockService.currentLong(), timestamp));
    }

    private void writeError(long requestId, int opCode, Throwable err, ChannelHandlerContext ctx, boolean isNotification) {
        if (LOG.isDebugEnabled()) {
            if (isNotification) {
                LOG.debug("Error processing client notification [connectionId=" + this.connectionId + ", id=" + requestId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]:" + err.getMessage(), err);
            } else {
                LOG.debug("Error processing client request [connectionId=" + this.connectionId + ", id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]:" + err.getMessage(), err);
            }
        }
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(ctx.alloc());
        try {
            assert (err != null);
            this.writeResponseHeader(packer, requestId, ctx, isNotification, true, 0L);
            this.writeErrorCore(err, packer);
            this.writeAndFlush(packer, ctx);
        }
        catch (Throwable t) {
            packer.close();
            this.exceptionCaught(ctx, t);
        }
    }

    private void writeErrorCore(Throwable err, ClientMessagePacker packer) {
        SqlBatchException sqlBatchException;
        SchemaVersionMismatchException schemaVersionMismatchException = ClientInboundMessageHandler.findException(err, SchemaVersionMismatchException.class);
        if ((err = IgniteUtils.firstNotNull(schemaVersionMismatchException, sqlBatchException = ClientInboundMessageHandler.findException(err, SqlBatchException.class), ExceptionUtils.unwrapCause(err))) instanceof TraceableException) {
            TraceableException iex = (TraceableException)((Object)err);
            packer.packUuid(iex.traceId());
            packer.packInt(iex.code());
        } else {
            packer.packUuid(UUID.randomUUID());
            packer.packInt(ErrorGroups.Common.INTERNAL_ERR);
        }
        assert (err != null);
        Throwable pubErr = IgniteExceptionMapperUtil.mapToPublicException(err);
        packer.packString(pubErr.getClass().getName());
        packer.packString(pubErr.getMessage());
        if (this.configuration.sendServerExceptionStackTraceToClient()) {
            packer.packString(ExceptionUtils.getFullStackTrace(pubErr));
        } else {
            packer.packString("To see the full stack trace set clientConnector.sendServerExceptionStackTraceToClient:true");
        }
        if (schemaVersionMismatchException != null) {
            packer.packInt(1);
            packer.packString("expected-schema-ver");
            packer.packInt(schemaVersionMismatchException.expectedVersion());
        } else if (sqlBatchException != null) {
            packer.packInt(1);
            packer.packString("sql-update-counters");
            packer.packLongArray(sqlBatchException.updateCounters());
        } else {
            packer.packNil();
        }
    }

    private static ClientMessagePacker getPacker(ByteBufAllocator alloc) {
        return new ClientMessagePacker(alloc.buffer());
    }

    private void processOperation(ChannelHandlerContext ctx, ClientMessageUnpacker in, SecurityContext securityContext) {
        long requestId = -1L;
        int opCode = -1;
        this.metrics.requestsActiveIncrement();
        try {
            opCode = in.unpackInt();
            requestId = in.unpackLong();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Client request started [id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
            }
            if (opCode == 73) {
                this.processServerOpResponse(requestId, in);
                return;
            }
            if (ClientOp.isPartitionOperation(opCode)) {
                long requestId0 = requestId;
                int opCode0 = opCode;
                this.partitionOperationsExecutor.execute(() -> {
                    try {
                        this.processOperationInSecurityContext(ctx, in, requestId0, opCode0, securityContext);
                    }
                    catch (Throwable t) {
                        in.close();
                        this.writeError(requestId0, opCode0, t, ctx, false);
                        this.metrics.requestsFailedIncrement();
                    }
                });
            } else {
                this.processOperationInSecurityContext(ctx, in, requestId, opCode, securityContext);
            }
        }
        catch (Throwable t) {
            in.close();
            this.writeError(requestId, opCode, t, ctx, false);
            this.metrics.requestsFailedIncrement();
        }
    }

    private CompletableFuture<ResponseWriter> processOperation(ClientMessageUnpacker in, int opCode, long requestId, HybridTimestampTracker tsTracker) throws IgniteInternalCheckedException {
        switch (opCode) {
            case 1: {
                return CompletableFutures.nullCompletedFuture();
            }
            case 3: {
                return ClientTablesGetRequest.process(this.igniteTables).thenApply(x -> {
                    tsTracker.update(this.clockService.current());
                    return x;
                });
            }
            case 5: {
                return ClientSchemasGetRequest.process(in, this.igniteTables, this.schemaVersions);
            }
            case 4: {
                return ClientTableGetRequest.process(in, this.igniteTables);
            }
            case 10: {
                return ClientTupleUpsertRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 12: {
                return ClientTupleGetRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, tsTracker);
            }
            case 13: {
                return ClientTupleUpsertAllRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 15: {
                return ClientTupleGetAllRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, tsTracker);
            }
            case 16: {
                return ClientTupleGetAndUpsertRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 18: {
                return ClientTupleInsertRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 20: {
                return ClientTupleInsertAllRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 22: {
                return ClientTupleReplaceRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 24: {
                return ClientTupleReplaceExactRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 26: {
                return ClientTupleGetAndReplaceRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 28: {
                return ClientTupleDeleteRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 29: {
                return ClientTupleDeleteAllRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 30: {
                return ClientTupleDeleteExactRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 31: {
                return ClientTupleDeleteAllExactRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 32: {
                return ClientTupleGetAndDeleteRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, this.notificationSender(requestId), tsTracker);
            }
            case 33: {
                return ClientTupleContainsKeyRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, tsTracker);
            }
            case 67: {
                return ClientTupleContainsAllKeysRequest.process(in, this.igniteTables, this.resources, this.txManager, this.clockService, tsTracker);
            }
            case 54: {
                return ClientJdbcConnectRequest.execute(in, this.jdbcQueryEventHandler, this.resolveCurrentUsername());
            }
            case 34: {
                return ClientJdbcExecuteRequest.execute(in, this.jdbcQueryEventHandler, tsTracker);
            }
            case 68: {
                return ClientJdbcCancelRequest.execute(in, this.jdbcQueryEventHandler);
            }
            case 36: {
                return ClientJdbcExecuteBatchRequest.process(in, this.jdbcQueryEventHandler, tsTracker);
            }
            case 46: {
                return ClientJdbcPreparedStmntBatchRequest.process(in, this.jdbcQueryEventHandler, tsTracker);
            }
            case 35: {
                return ClientJdbcFetchRequest.process(in, this.jdbcQueryCursorHandler);
            }
            case 58: {
                return ClientJdbcHasMoreRequest.process(in, this.jdbcQueryCursorHandler);
            }
            case 37: {
                return ClientJdbcCloseRequest.process(in, this.jdbcQueryCursorHandler);
            }
            case 38: {
                return ClientJdbcTableMetadataRequest.process(in, this.jdbcQueryEventHandler);
            }
            case 39: {
                return ClientJdbcColumnMetadataRequest.process(in, this.jdbcQueryEventHandler);
            }
            case 40: {
                return ClientJdbcSchemasMetadataRequest.process(in, this.jdbcQueryEventHandler).thenApply(x -> {
                    tsTracker.update(this.clockService.current());
                    return x;
                });
            }
            case 41: {
                return ClientJdbcPrimaryKeyMetadataRequest.process(in, this.jdbcQueryEventHandler);
            }
            case 43: {
                return ClientTransactionBeginRequest.process(in, this.txManager, this.resources, this.metrics, tsTracker, false);
            }
            case 44: {
                return ClientTransactionCommitRequest.process(in, this.resources, this.metrics, this.clockService, this.igniteTables, this.clientContext.hasFeature(ProtocolBitmaskFeature.TX_PIGGYBACK), tsTracker);
            }
            case 45: {
                return ClientTransactionRollbackRequest.process(in, this.resources, this.metrics, this.igniteTables, this.clientContext.hasFeature(ProtocolBitmaskFeature.TX_PIGGYBACK));
            }
            case 47: {
                return ClientComputeExecuteRequest.process(in, this.compute, this.clusterService, this.notificationSender(requestId), this.clientContext);
            }
            case 49: {
                return ClientComputeExecuteColocatedRequest.process(in, this.compute, this.igniteTables, this.clusterService, this.notificationSender(requestId), this.clientContext);
            }
            case 69: {
                return ClientComputeExecutePartitionedRequest.process(in, this.compute, this.igniteTables, this.clusterService, this.notificationSender(requestId), this.clientContext);
            }
            case 64: {
                return ClientComputeExecuteMapReduceRequest.process(in, this.compute, this.notificationSender(requestId), this.clientContext);
            }
            case 59: {
                return ClientComputeGetStateRequest.process(in, this.compute);
            }
            case 60: {
                return ClientComputeCancelRequest.process(in, this.compute);
            }
            case 61: {
                return ClientComputeChangePriorityRequest.process(in, this.compute);
            }
            case 48: {
                return ClientClusterGetNodesRequest.process(this.cluster);
            }
            case 50: {
                return ClientSqlExecuteRequest.process(this.partitionOperationsExecutor, in, requestId, this.cancelHandles, this.queryProcessor, this.resources, this.metrics, tsTracker, this.clientContext.hasFeature(ProtocolBitmaskFeature.SQL_PARTITION_AWARENESS), this.clientContext.hasFeature(ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING), this.txManager, this.clockService, this.notificationSender(requestId), this.resolveCurrentUsername());
            }
            case 70: {
                return ClientOperationCancelRequest.process(in, this.cancelHandles);
            }
            case 51: {
                return ClientSqlCursorNextPageRequest.process(in, this.resources);
            }
            case 52: {
                return ClientSqlCursorCloseRequest.process(in, this.resources);
            }
            case 53: {
                return ClientTablePartitionPrimaryReplicasGetRequest.process(in, this.primaryReplicaTracker);
            }
            case 55: {
                return ClientJdbcFinishTxRequest.process(in, this.jdbcQueryEventHandler, tsTracker);
            }
            case 56: {
                return ClientSqlExecuteScriptRequest.process(this.partitionOperationsExecutor, in, this.queryProcessor, requestId, this.cancelHandles, tsTracker, this.resolveCurrentUsername());
            }
            case 57: {
                return ClientSqlQueryMetadataRequest.process(this.partitionOperationsExecutor, in, this.queryProcessor, this.resources, tsTracker);
            }
            case 63: {
                return ClientSqlExecuteBatchRequest.process(this.partitionOperationsExecutor, in, this.queryProcessor, this.resources, requestId, this.cancelHandles, tsTracker, this.resolveCurrentUsername());
            }
            case 62: {
                return ClientStreamerBatchSendRequest.process(in, this.igniteTables);
            }
            case 65: {
                return ClientTablePartitionPrimaryReplicasNodesGetRequest.process(in, this.igniteTables);
            }
            case 66: {
                return ClientStreamerWithReceiverBatchSendRequest.process(in, this.igniteTables, this.clientContext.hasFeature(ProtocolBitmaskFeature.STREAMER_RECEIVER_EXECUTION_OPTIONS), tsTracker);
            }
            case 71: {
                return ClientTablesGetQualifiedRequest.process(this.igniteTables).thenApply(x -> {
                    tsTracker.update(this.clockService.current());
                    return x;
                });
            }
            case 72: {
                return ClientTableGetQualifiedRequest.process(in, this.igniteTables);
            }
            case 1001: {
                return ClientContinuousQueryScanRequest.process(in, this.igniteTables, this.clientContext.hasFeature(ProtocolBitmaskFeature.CQ_EVENT_TYPE), this.clientContext.hasFeature(ProtocolBitmaskFeature.CQ_PARTITION_SCAN_STATUS), this.clientContext.hasFeature(ProtocolBitmaskFeature.CQ_SKIP_OLD_ENTRIES));
            }
            case 1002: {
                return ClientCachesGetRequest.process(in, this.igniteTables);
            }
            case 1003: {
                return ClientCacheGetRequest.process(in, this.igniteTables);
            }
            case 1006: {
                return ClientCacheGetQualifiedRequest.process(in, this.igniteTables);
            }
            case 1005: {
                return ClientCachesGetQualifiedRequest.process(in, this.igniteTables);
            }
            case 1004: {
                return ClientTransactionBeginRequest.process(in, this.txManager, this.resources, this.metrics, tsTracker, true);
            }
            case 1007: {
                return ClientGetOrCreateMapRequest.process(in, this.structures, this.catalogService);
            }
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected operation code: " + opCode);
    }

    private String resolveCurrentUsername() {
        return this.clientContext.userDetails().username();
    }

    private void processOperationInSecurityContext(ChannelHandlerContext ctx, ClientMessageUnpacker in, long requestId, int opCode, SecurityContext securityContext) {
        GridGainSecurity.with(securityContext, () -> this.processOperationInternal(ctx, in, requestId, opCode)).run();
    }

    private void processOperationInternal(ChannelHandlerContext ctx, ClientMessageUnpacker in, long requestId, int opCode) {
        CompletableFuture<Object> fut;
        HybridTimestampTracker tsTracker = HybridTimestampTracker.atomicTracker(null);
        try (ClientMessageUnpacker clientMessageUnpacker = in;){
            fut = this.processOperation(in, opCode, requestId, tsTracker);
        }
        catch (IgniteInternalCheckedException e) {
            fut = CompletableFuture.failedFuture(e);
        }
        fut.whenComplete((res, err) -> {
            this.metrics.requestsActiveDecrement();
            if (err != null) {
                this.writeError(requestId, opCode, (Throwable)err, ctx, false);
                this.metrics.requestsFailedIncrement();
                return;
            }
            ClientMessagePacker out = ClientInboundMessageHandler.getPacker(ctx.alloc());
            try {
                out.packLong(requestId);
                this.writeFlags(out, ctx, false, false);
                int observableTsIdx = out.reserveLong();
                if (res != null) {
                    res.write(out);
                }
                out.setLong(observableTsIdx, tsTracker.getLong());
                this.writeAndFlush(out, ctx);
                this.metrics.requestsProcessedIncrement();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Client request processed [id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
                }
            }
            catch (Throwable e) {
                out.close();
                this.writeError(requestId, opCode, e, ctx, false);
                this.metrics.requestsFailedIncrement();
            }
        });
    }

    private void writeFlags(ClientMessagePacker out, ChannelHandlerContext ctx, boolean isNotification, boolean isError) {
        boolean primaryReplicasUpdated;
        long lastSentMaxStartTime = this.primaryReplicaMaxStartTime.get();
        long currentMaxStartTime = this.primaryReplicaTracker.maxStartTime();
        boolean bl = primaryReplicasUpdated = currentMaxStartTime > lastSentMaxStartTime && this.primaryReplicaMaxStartTime.compareAndSet(lastSentMaxStartTime, currentMaxStartTime);
        if (primaryReplicasUpdated && LOG.isInfoEnabled()) {
            LOG.info("Partition primary replica changed, notifying client [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
        int flags = ResponseFlags.getFlags(primaryReplicasUpdated, isNotification, isError, false);
        out.packInt(flags);
        if (primaryReplicasUpdated) {
            out.packLong(currentMaxStartTime);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        boolean logWarn = true;
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
            this.metrics.sessionsRejectedTlsIncrement();
            logWarn = false;
        }
        if (cause instanceof DecoderException && cause.getCause() instanceof IgniteException) {
            IgniteException err = (IgniteException)cause.getCause();
            if (err.code() == ErrorGroups.Client.HANDSHAKE_HEADER_ERR) {
                this.metrics.sessionsRejectedIncrement();
            }
            logWarn = false;
        }
        if (logWarn) {
            LOG.warn("Exception in client connector pipeline [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + cause.getMessage(), cause);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Exception in client connector pipeline [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + cause.getMessage(), cause);
        }
        ctx.close();
    }

    @Nullable
    private static <T> T findException(Throwable e, Class<T> cls) {
        while (e != null) {
            if (cls.isInstance(e)) {
                return (T)e;
            }
            e = e.getCause();
        }
        return null;
    }

    private void sendNotification(long requestId, @Nullable Consumer<ClientMessagePacker> writer, @Nullable Throwable err, long timestamp) {
        if (err != null) {
            this.writeError(requestId, -1, err, this.channelHandlerContext, true);
            return;
        }
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(this.channelHandlerContext.alloc());
        try {
            this.writeResponseHeader(packer, requestId, this.channelHandlerContext, true, false, timestamp);
            if (writer != null) {
                writer.accept(packer);
            }
            this.writeAndFlush(packer, this.channelHandlerContext);
        }
        catch (Throwable t) {
            packer.close();
            this.exceptionCaught(this.channelHandlerContext, t);
        }
    }

    private NotificationSender notificationSender(long requestId) {
        return (writer, err, hybridTimestamp) -> this.sendNotification(requestId, writer, err, hybridTimestamp);
    }

    @Override
    public CompletableFuture<Boolean> notify(AuthenticationEventParameters parameters) {
        ChannelHandlerContext channelCtx = this.channelHandlerContext;
        if (channelCtx == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        channelCtx.executor().submit(() -> {
            if (this.shouldCloseConnection(parameters)) {
                LOG.warn("Closing connection due to authentication event [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(this.channelHandlerContext.channel().remoteAddress()) + ", event=" + String.valueOf(parameters.type()) + "]", new Object[0]);
                this.closeConnection();
            }
        });
        return CompletableFutures.falseCompletedFuture();
    }

    private boolean shouldCloseConnection(AuthenticationEventParameters parameters) {
        switch (parameters.type()) {
            case AUTHENTICATION_ENABLED: {
                return true;
            }
            case AUTHENTICATION_PROVIDER_REMOVED: 
            case AUTHENTICATION_PROVIDER_UPDATED: {
                return this.currentUserAffected((AuthenticationProviderEventParameters)parameters);
            }
            case USER_REMOVED: 
            case USER_UPDATED: {
                return this.currentUserAffected((UserEventParameters)parameters);
            }
        }
        return false;
    }

    private boolean currentUserAffected(AuthenticationProviderEventParameters parameters) {
        return this.clientContext != null && this.clientContext.userDetails().providerName().equals(parameters.name());
    }

    private boolean currentUserAffected(UserEventParameters parameters) {
        return this.clientContext != null && this.clientContext.userDetails().providerName().equals(parameters.providerName()) && this.clientContext.userDetails().username().equals(parameters.username());
    }

    private void closeConnection() {
        ChannelHandlerContext ctx = this.channelHandlerContext;
        if (ctx != null) {
            ctx.close();
        }
    }

    private static Set<AuthenticationEvent> authenticationEventsToSubscribe() {
        return Set.of(AuthenticationEvent.AUTHENTICATION_ENABLED, AuthenticationEvent.AUTHENTICATION_PROVIDER_UPDATED, AuthenticationEvent.AUTHENTICATION_PROVIDER_REMOVED, AuthenticationEvent.USER_UPDATED, AuthenticationEvent.USER_REMOVED);
    }

    @TestOnly
    public ClientResourceRegistry resources() {
        return this.resources;
    }

    @TestOnly
    public int cancelHandlesCount() {
        return this.cancelHandles.size();
    }

    private CompletableFuture<ClientMessageUnpacker> sendServerToClientRequest(int serverOp, Consumer<ClientMessagePacker> writer) {
        long requestId = this.serverToClientRequestId.decrementAndGet();
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(this.channelHandlerContext.alloc());
        try {
            packer.packLong(requestId);
            int flags = ResponseFlags.getFlags(false, false, false, true);
            packer.packInt(flags);
            packer.packLong(this.clockService.currentLong());
            packer.packInt(serverOp);
            writer.accept(packer);
            CompletableFuture<ClientMessageUnpacker> fut = new CompletableFuture<ClientMessageUnpacker>();
            this.serverToClientRequests.put(requestId, fut);
            this.writeAndFlush(packer, this.channelHandlerContext);
            return fut;
        }
        catch (Throwable t) {
            packer.close();
            this.serverToClientRequests.remove(requestId);
            return CompletableFuture.failedFuture(t);
        }
    }

    private void processServerOpResponse(long requestId, ClientMessageUnpacker in) {
        try (ClientMessageUnpacker clientMessageUnpacker = in;){
            CompletableFuture<ClientMessageUnpacker> fut = this.serverToClientRequests.remove(requestId);
            if (fut == null) {
                LOG.warn("Received SERVER_OP_RESPONSE with unknown id [id=" + requestId + ", connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(this.channelHandlerContext.channel().remoteAddress()) + "]", new Object[0]);
                return;
            }
            int flags = in.unpackInt();
            boolean error = ServerOpResponseFlags.getErrorFlag(flags);
            if (!error) {
                fut.complete(in.retain());
            } else {
                Throwable err = this.readErrorFromClient(requestId, in);
                fut.completeExceptionally(err);
            }
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error while processing SERVER_OP_RESPONSE [id=" + requestId + ", connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(this.channelHandlerContext.channel().remoteAddress()) + ", message=" + t.getMessage() + "]", t);
        }
    }

    private Throwable readErrorFromClient(long requestId, ClientMessageUnpacker r) {
        UUID traceId = r.tryUnpackNil() ? UUID.randomUUID() : r.unpackUuid();
        int code = r.tryUnpackNil() ? ErrorGroups.Common.INTERNAL_ERR : r.unpackInt();
        String className = r.unpackString();
        String message = r.tryUnpackNil() ? "Unknown error" : r.unpackString();
        String stackTrace = r.unpackStringNullable();
        int extCount = r.unpackInt();
        for (int i = 0; i < extCount; ++i) {
            String extName = r.unpackString();
            LOG.warn("Ignoring unknown error extension from client [id=" + requestId + ", connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(this.channelHandlerContext.channel().remoteAddress()) + ", key=" + extName + "]", new Object[0]);
            r.skipValues(1);
        }
        RuntimeException cause = new RuntimeException(className + ": " + message + System.lineSeparator() + stackTrace);
        return new IgniteException(traceId, code, message, cause);
    }

    private static void packDeploymentUnitPaths(List<String> deploymentUnitPaths, ClientMessagePacker packer) {
        packer.packInt(deploymentUnitPaths.size());
        for (String path : deploymentUnitPaths) {
            packer.packString(path);
        }
    }

    private static void packDeploymentUnitPaths(Collection<DeploymentUnitInfo> deploymentUnits, ClientMessagePacker packer) {
        packer.packInt(deploymentUnits.size());
        for (DeploymentUnitInfo unit : deploymentUnits) {
            try {
                packer.packString(unit.path().toRealPath(new LinkOption[0]).toString());
            }
            catch (IOException e) {
                throw (RuntimeException)ExceptionUtils.sneakyThrow(e);
            }
        }
    }

    private class ComputeConnection
    implements PlatformComputeConnection {
        private ComputeConnection() {
        }

        @Override
        public CompletableFuture<ComputeJobDataHolder> executeJobAsync(long jobId, String jobClassName, JobExecutionContext ctx, @Nullable ComputeJobDataHolder arg) {
            return ClientInboundMessageHandler.this.sendServerToClientRequest(2, packer -> {
                packer.packLong(jobId);
                packer.packString(jobClassName);
                ClientInboundMessageHandler.packDeploymentUnitPaths(ctx.deploymentUnits(), packer);
                packer.packBoolean(false);
                ClientComputeJobPacker.packJobArgument(arg, null, packer);
            }).thenApply(unpacker -> {
                try (ClientMessageUnpacker clientMessageUnpacker = unpacker;){
                    ComputeJobDataHolder computeJobDataHolder = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller(unpacker);
                    return computeJobDataHolder;
                }
            });
        }

        @Override
        public CompletableFuture<Boolean> cancelJobAsync(long jobId) {
            return ClientInboundMessageHandler.this.sendServerToClientRequest(3, packer -> packer.packLong(jobId)).thenApply(unpacker -> {
                try (ClientMessageUnpacker clientMessageUnpacker = unpacker;){
                    Boolean bl = unpacker.unpackBoolean();
                    return bl;
                }
            });
        }

        @Override
        public CompletableFuture<Boolean> undeployUnitsAsync(List<String> deploymentUnitPaths) {
            return ClientInboundMessageHandler.this.sendServerToClientRequest(4, packer -> ClientInboundMessageHandler.packDeploymentUnitPaths(deploymentUnitPaths, packer)).thenApply(unpacker -> {
                try (ClientMessageUnpacker clientMessageUnpacker = unpacker;){
                    Boolean bl = unpacker.unpackBoolean();
                    return bl;
                }
            });
        }

        @Override
        public void close() {
            ClientInboundMessageHandler.this.closeConnection();
        }

        @Override
        public boolean isActive() {
            ChannelHandlerContext ctx = ClientInboundMessageHandler.this.channelHandlerContext;
            return ctx != null && ctx.channel().isActive();
        }
    }
}

