/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.binary;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class BinaryTypeConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private BinaryIdMapper idMapper;
    private BinaryNameMapper nameMapper;
    private BinarySerializer serializer;
    private boolean isEnum;
    private Map<String, Integer> enumValues;

    public BinaryTypeConfiguration() {
    }

    public BinaryTypeConfiguration(BinaryTypeConfiguration other) {
        A.notNull((Object)other, (String)"other");
        this.idMapper = other.idMapper;
        this.isEnum = other.isEnum;
        this.serializer = other.serializer;
        this.enumValues = other.enumValues != null ? new LinkedHashMap<String, Integer>(other.enumValues) : null;
        this.typeName = other.typeName;
    }

    public BinaryTypeConfiguration(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public BinaryTypeConfiguration setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public BinaryIdMapper getIdMapper() {
        return this.idMapper;
    }

    public BinaryTypeConfiguration setIdMapper(BinaryIdMapper idMapper) {
        this.idMapper = idMapper;
        return this;
    }

    public BinaryNameMapper getNameMapper() {
        return this.nameMapper;
    }

    public BinaryTypeConfiguration setNameMapper(BinaryNameMapper nameMapper) {
        this.nameMapper = nameMapper;
        return this;
    }

    public BinarySerializer getSerializer() {
        return this.serializer;
    }

    public BinaryTypeConfiguration setSerializer(BinarySerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public BinaryTypeConfiguration setEnum(boolean isEnum) {
        this.isEnum = isEnum;
        return this;
    }

    public BinaryTypeConfiguration setEnumValues(@Nullable Map<String, Integer> values) {
        this.enumValues = values;
        return this;
    }

    @Nullable
    public Map<String, Integer> getEnumValues() {
        return this.enumValues;
    }

    public String toString() {
        return S.toString(BinaryTypeConfiguration.class, (Object)this, (String)super.toString());
    }
}

