/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.binary;

import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.internal.util.typedef.internal.A;

public class BinaryBasicNameMapper
implements BinaryNameMapper {
    public static final boolean DFLT_SIMPLE_NAME = false;
    private boolean isSimpleName = false;

    public BinaryBasicNameMapper() {
    }

    public BinaryBasicNameMapper(boolean isSimpleName) {
        this.isSimpleName = isSimpleName;
    }

    public boolean isSimpleName() {
        return this.isSimpleName;
    }

    public BinaryBasicNameMapper setSimpleName(boolean isSimpleName) {
        this.isSimpleName = isSimpleName;
        return this;
    }

    @Override
    public String typeName(String clsName) {
        A.notNull((Object)clsName, (String)"clsName");
        return this.isSimpleName ? BinaryBasicNameMapper.simpleName(clsName) : clsName;
    }

    @Override
    public String fieldName(String fieldName) {
        A.notNull((Object)fieldName, (String)"fieldName");
        return fieldName;
    }

    private static String simpleName(String clsName) {
        assert (clsName != null);
        int idx = (clsName = BinaryBasicNameMapper.simplifyDotNetGenerics(clsName)).lastIndexOf(36);
        if (idx == clsName.length() - 1) {
            idx = -1;
        } else if (idx >= 0) {
            String typeName = clsName.substring(idx + 1);
            try {
                Integer.parseInt(typeName);
                idx = -1;
            }
            catch (NumberFormatException ignore) {
                if (clsName.indexOf("$$Lambda$") > 0) {
                    idx = -1;
                }
                return typeName;
            }
        }
        if (idx < 0) {
            idx = clsName.lastIndexOf(43);
        }
        if (idx < 0) {
            idx = clsName.lastIndexOf(46);
        }
        return idx >= 0 ? clsName.substring(idx + 1) : clsName;
    }

    private static String simplifyDotNetGenerics(String clsName) {
        int genericIdx = clsName.indexOf("[[");
        if (genericIdx > 0) {
            clsName = clsName.substring(0, genericIdx + 2) + BinaryBasicNameMapper.simpleName(clsName.substring(genericIdx + 2));
        }
        if ((genericIdx = clsName.indexOf("],[", genericIdx)) > 0) {
            clsName = clsName.substring(0, genericIdx + 3) + BinaryBasicNameMapper.simpleName(clsName.substring(genericIdx + 3));
        }
        return clsName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryBasicNameMapper)) {
            return false;
        }
        BinaryBasicNameMapper mapper = (BinaryBasicNameMapper)o;
        return this.isSimpleName == mapper.isSimpleName;
    }

    public int hashCode() {
        return this.isSimpleName ? 1 : 0;
    }

    public String toString() {
        return "BinaryBaseNameMapper [isSimpleName=" + this.isSimpleName + ']';
    }
}

