/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public abstract class Query<R>
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_PAGE_SIZE = 1024;
    private int pageSize = 1024;
    private boolean loc;

    Query() {
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Query<R> setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be above zero.");
        }
        this.pageSize = pageSize;
        return this;
    }

    public boolean isLocal() {
        return this.loc;
    }

    public Query<R> setLocal(boolean loc) {
        this.loc = loc;
        return this;
    }

    protected int[] prepare(int[] parts) {
        int i;
        if (parts == null) {
            return null;
        }
        A.notEmpty((int[])parts, (String)"Partitions");
        boolean sorted = true;
        for (i = 0; i < parts.length; ++i) {
            if (i < parts.length - 1) {
                if (parts[i] > parts[i + 1]) {
                    sorted = false;
                } else if (sorted) {
                    this.validateDups(parts[i], parts[i + 1]);
                }
            }
            A.ensure((0 <= parts[i] && parts[i] < 65000 ? 1 : 0) != 0, (String)"Illegal partition");
        }
        if (!sorted) {
            Arrays.sort(parts);
            for (i = 0; i < parts.length; ++i) {
                if (i >= parts.length - 1) continue;
                this.validateDups(parts[i], parts[i + 1]);
            }
        }
        return parts;
    }

    private void validateDups(int p1, int p2) {
        A.ensure((p1 != p2 ? 1 : 0) != 0, (String)("Partition duplicates are not allowed: " + p1));
    }

    public String toString() {
        return S.toString(Query.class, (Object)this);
    }
}

