/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import com.google.auto.service.AutoService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;
import org.apache.ignite.table.Table;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class IntArrayCachesTest {
    private static final String GROUP_NAME = "CollectionTypeCaches";
    private static final String KEY_COLUMN_NAME = "ID";
    private static final String VAL_COLUMN_NAME = "VAL";

    @AutoService(value={ExampleBasedCacheTest.class})
    public static class ListTest
    extends VeryBasicAbstractCacheTest<Integer, List> {
        public ListTest() {
            super(Integer.class, List.class, IntArrayCachesTest.KEY_COLUMN_NAME);
        }

        @Override
        public CacheConfiguration<Integer, List> cacheConfiguration() {
            return super.cacheConfiguration().setGroupName(IntArrayCachesTest.GROUP_NAME);
        }

        public String getTableName() {
            return "MyListArrCache";
        }

        public Map.Entry<Integer, List> supplyExample(int seed) {
            int n1 = seed;
            int n2 = seed * 100;
            int sum = n1 + n2;
            List<Integer> n = List.of(Integer.valueOf(sum), Integer.valueOf(n1), Integer.valueOf(n2));
            return Map.entry(seed, n);
        }

        @Override
        public void testIgnite3(Table ignite3Table, int numGeneratedExamples) {
            Assumptions.abort((String)"There is currently no canonical way of mapping List caches to ignite 3");
        }

        @Override
        protected void assertResultSet(ResultSet rs, List expectedObj) throws SQLException {
            Assumptions.abort((String)"Currently the JDBC driver does not support adapting binary to concrete types");
            List actual = (List)rs.getObject(IntArrayCachesTest.VAL_COLUMN_NAME);
            Assertions.assertThat((List)actual).isEqualTo((Object)expectedObj);
        }
    }

    @AutoService(value={ExampleBasedCacheTest.class})
    public static class PrimitiveTest
    extends VeryBasicAbstractCacheTest<Integer, int[]> {
        public PrimitiveTest() {
            super(Integer.class, int[].class, IntArrayCachesTest.KEY_COLUMN_NAME);
        }

        @Override
        public CacheConfiguration<Integer, int[]> cacheConfiguration() {
            return super.cacheConfiguration().setGroupName(IntArrayCachesTest.GROUP_NAME);
        }

        public String getTableName() {
            return "MyIntArrCache";
        }

        public Map.Entry<Integer, int[]> supplyExample(int seed) {
            int n1 = seed;
            int n2 = seed * 100;
            int sum = n1 + n2;
            int[] n = new int[]{sum, n1, n2};
            return Map.entry(seed, n);
        }

        @Override
        public void testIgnite3(Table ignite3Table, int numGeneratedExamples) {
            Assumptions.abort((String)"There is currently no canonical way of mapping int[] cache to ignite 3");
        }

        @Override
        protected void assertResultSet(ResultSet rs, int[] expectedObj) throws SQLException {
            Assumptions.abort((String)"Currently the JDBC driver does not support adapting binary to concrete types");
            int[] actual = rs.getObject(IntArrayCachesTest.VAL_COLUMN_NAME, int[].class);
            Assertions.assertThat((int[])actual).isEqualTo((Object)expectedObj);
        }
    }
}

