/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import com.google.auto.service.AutoService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.tests.e2e.custom.MySqlFunctions;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;

@AutoService(value={ExampleBasedCacheTest.class})
public class MySimpleMapCacheTest
extends VeryBasicAbstractCacheTest<String, Integer> {
    private static final String SCHEMA_NAME_CASED = "My_Custom_Schema";

    public MySimpleMapCacheTest() {
        super(String.class, Integer.class, "ID");
    }

    @Override
    public CacheConfiguration<String, Integer> cacheConfiguration() {
        CacheConfiguration cfg = super.cacheConfiguration();
        cfg.setSqlSchema(SCHEMA_NAME_CASED);
        cfg.setSqlFunctionClasses(new Class[]{MySqlFunctions.class});
        return cfg;
    }

    public String getTableName() {
        return "MySimpleMap";
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return SCHEMA_NAME_CASED.toUpperCase();
    }

    public Map.Entry<String, Integer> supplyExample(int seed) {
        return Map.entry("MyKey:" + seed, seed);
    }

    @Override
    protected void assertResultSet(ResultSet rs, Integer expectedObj) throws SQLException {
        Assertions.assertThat((int)rs.getInt("VAL")).isEqualTo((Object)expectedObj);
    }
}

