/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite.examples.model.Address;
import org.apache.ignite.examples.model.Organization;
import org.apache.ignite.examples.model.OrganizationType;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;
import org.apache.ignite.table.mapper.Mapper;
import org.assertj.core.api.Assertions;

@AutoService(value={ExampleBasedCacheTest.class})
public class MyOrganizationsCacheTest
extends VeryBasicAbstractCacheTest<Long, Organization> {
    private static OrganizationType[] FROZEN_ORG_TYPES = new OrganizationType[]{OrganizationType.GOVERNMENT, OrganizationType.PRIVATE, OrganizationType.NON_PROFIT};

    public MyOrganizationsCacheTest() {
        super(Long.class, Organization.class);
    }

    public String getTableName() {
        return "MyOrganizations";
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public Map.Entry<Long, Organization> supplyExample(int seed) {
        Random r = new Random(100 + seed);
        int port = r.nextInt(100);
        int zip = 1000 + r.nextInt(9000);
        Address addr = new Address("My Address " + port, zip);
        int typeRnd = r.nextInt(3);
        OrganizationType type = FROZEN_ORG_TYPES[typeRnd];
        long timestampRng = (long)r.nextInt(Integer.MAX_VALUE) * 1000L;
        Organization o = new Organization("organization-" + seed, addr, type, new Timestamp(timestampRng));
        try {
            FieldUtils.writeField((Object)o, (String)"id", (Object)seed, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Map.entry(Long.valueOf(seed), o);
    }

    @Override
    protected Mapper<Organization> valMapper() {
        return Mapper.builder(Organization.class).map("id", "ID", new String[0]).map("name", "NAME", new String[0]).build();
    }

    @Override
    protected void assertValueFromIgnite3(Organization actualVal, Organization expected) {
        Assertions.assertThat((Object)actualVal).extracting(new Function[]{Organization::id, Organization::name, Organization::address, Organization::type, Organization::lastUpdated}).containsExactly(new Object[]{expected.id(), expected.name(), null, null, null});
    }

    @Override
    protected void assertResultSet(ResultSet rs, Organization expectedObj) throws SQLException {
        Assertions.assertThat((long)rs.getLong("ID")).isEqualTo((Object)expectedObj.id());
        Assertions.assertThat((String)rs.getString("NAME")).isEqualTo(expectedObj.name());
    }
}

