/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import com.google.auto.service.AutoService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.examples.model.Person;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;
import org.assertj.core.api.Assertions;

@AutoService(value={ExampleBasedCacheTest.class})
public class PersonCacheTest
extends VeryBasicAbstractCacheTest<Integer, Person> {
    public PersonCacheTest() {
        super(Integer.class, Person.class);
    }

    public String getTableName() {
        return "MyPersonPojoCache";
    }

    public Map.Entry<Integer, Person> supplyExample(int seed) {
        Person p = new Person(Long.valueOf(seed), Long.valueOf(1000000L + (long)seed), "Some First Name", "Some Last Name", 200.25 * (double)seed, "Unremarkable");
        return Map.entry(seed, p);
    }

    @Override
    protected void assertResultSet(ResultSet rs, Person expectedObj) throws SQLException {
        Assertions.assertThat((long)rs.getLong("ID")).isEqualTo((Object)expectedObj.id);
        Assertions.assertThat((long)rs.getLong("orgId")).isEqualTo((Object)expectedObj.orgId);
        Assertions.assertThat((String)rs.getString("firstName")).isEqualTo(expectedObj.firstName);
        Assertions.assertThat((String)rs.getString("lastName")).isEqualTo(expectedObj.lastName);
        Assertions.assertThat((String)rs.getString("resume")).isEqualTo(expectedObj.resume);
        Assertions.assertThat((double)rs.getDouble("salary")).isEqualTo(expectedObj.salary);
    }
}

