/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.examples.model.Organization;
import org.apache.ignite.examples.model.Person;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.SqlTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.MyOrganizationsCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.PersonCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;

public class MyBinaryKeyValueCacheTest {

    @AutoService(value={ExampleBasedCacheTest.class})
    public static class MyBinaryTestCache
    extends AbstractBinaryCache {
        public String getTableName() {
            return "MyBinaryTestCache";
        }

        public Map.Entry<Object, Object> supplyExample(int seed) {
            String key = "MyKey:" + seed;
            String myVal = "MyValue" + seed;
            return Map.entry(key.getBytes(StandardCharsets.UTF_8), myVal.getBytes(StandardCharsets.UTF_8));
        }
    }

    @AutoService(value={ExampleBasedCacheTest.class})
    public static class MyBinaryOrganizationCache
    extends AbstractBinaryCache {
        public String getTableName() {
            return "MyBinaryOrganizationCache";
        }

        public Map.Entry<Object, Object> supplyExample(int seed) {
            MyOrganizationsCacheTest delegate = new MyOrganizationsCacheTest();
            Map.Entry<Long, Organization> example = delegate.supplyExample(seed);
            return Map.entry(example.getKey(), example.getValue());
        }
    }

    @AutoService(value={ExampleBasedCacheTest.class})
    public static class MyBinaryPersonPojoCache
    extends AbstractBinaryCache {
        public String getTableName() {
            return "MyBinaryPersonPojoCache";
        }

        public Map.Entry<Object, Object> supplyExample(int seed) {
            PersonCacheTest delegate = new PersonCacheTest();
            Map.Entry<Integer, Person> example = delegate.supplyExample(seed);
            return Map.entry(example.getKey(), example.getValue());
        }
    }

    static abstract class AbstractBinaryCache
    extends VeryBasicAbstractCacheTest<Object, Object> {
        public AbstractBinaryCache() {
            super(null, null);
        }

        @Override
        public CacheConfiguration<Object, Object> cacheConfiguration() {
            CacheConfiguration cacheCfg = new CacheConfiguration(this.getTableName());
            cacheCfg.setGroupName("BinaryCaches");
            cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cacheCfg.setBackups(1);
            cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            return cacheCfg;
        }

        @Override
        public Map<String, SqlTest> jdbcTests() {
            return Collections.emptyMap();
        }
    }
}

