/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.NameUtils;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.SqlTest;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.SqlTestUtils;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.mapper.Mapper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ClassAssert;
import org.jetbrains.annotations.Nullable;

public abstract class VeryBasicAbstractCacheTest<K, V>
implements ExampleBasedCacheTest<K, V> {
    private static final String MAPPER_ERROR_MSG = "Test still not defined for binary caches";
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final String keyColumnName;

    public VeryBasicAbstractCacheTest(Class<K> keyClass, Class<V> valueClass) {
        this(keyClass, valueClass, "ID");
    }

    public VeryBasicAbstractCacheTest(Class<K> keyClass, Class<V> valueClass, String keyColumnName) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keyColumnName = keyColumnName;
    }

    public static <K, V> CacheConfiguration<K, V> createCacheConfiguration(String name, Class<K> keyType, Class<V> valType) {
        CacheConfiguration cacheCfg = new CacheConfiguration(name);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setBackups(1);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setIndexedTypes(new Class[]{keyType, valType});
        return cacheCfg;
    }

    @Nullable
    public String getSchemaName() {
        return null;
    }

    public CacheConfiguration<K, V> cacheConfiguration() {
        return VeryBasicAbstractCacheTest.createCacheConfiguration(this.getTableName(), this.keyClass, this.valueClass);
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public void testIgnite2(IgniteCache<K, V> cache, int numGeneratedExamples) {
        Assertions.assertThat((long)cache.sizeLong(new CachePeekMode[0])).isEqualTo((long)numGeneratedExamples);
        Random r = new Random();
        int expectedSeed = r.nextInt(numGeneratedExamples);
        Map.Entry expected = this.supplyExample(expectedSeed);
        Object actualVal = cache.get(expected.getKey());
        this.assertValueFromIgnite2(actualVal, expected.getValue());
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public void testIgnite3(Table ignite3Table, int numGeneratedExamples) {
        Mapper<K> keyMapper = this.keyMapper();
        Mapper<V> valMapper = this.valMapper();
        KeyValueView kvView = ignite3Table.keyValueView(keyMapper, valMapper);
        Random r = new Random();
        int expectedSeed = r.nextInt(numGeneratedExamples);
        Map.Entry expected = this.supplyExample(expectedSeed);
        Object actualVal = kvView.get(null, expected.getKey());
        this.assertValueFromIgnite3(actualVal, expected.getValue());
    }

    public Map<String, SqlTest> jdbcTests() {
        String tableName = NameUtils.ignite3TableName((ExampleBasedCacheTest)this);
        return Map.of("Count Test", (conn, numExamples) -> SqlTestUtils.sqlCountRecordsTest((Connection)conn, (String)tableName, (int)numExamples), "Element Iterator Test", (conn, numExamples) -> SqlTestUtils.sqlRandomElementTest((Connection)conn, (String)tableName, (String)this.keyColumnName, (int)numExamples, arg_0 -> ((VeryBasicAbstractCacheTest)this).supplyExample(arg_0), (expectedObj, resultSet) -> {
            try {
                this.assertResultSet((ResultSet)resultSet, (V)expectedObj);
            }
            catch (SQLException e) {
                org.junit.jupiter.api.Assertions.fail((Throwable)e);
            }
        }));
    }

    private String getSqlTableName() {
        Object tableName = this.valueClass.isArray() ? "\"" + this.valueClass.getName() + "\"" : this.valueClass.getSimpleName();
        return "\"" + this.getTableName() + "\"." + ((String)tableName).toUpperCase();
    }

    protected void assertValueFromIgnite2(V actualVal, V expected) {
        Assertions.assertThat(actualVal).usingRecursiveComparison().isEqualTo(expected);
    }

    protected void assertValueFromIgnite3(V actualVal, V expected) {
        Assertions.assertThat(actualVal).usingRecursiveComparison().isEqualTo(expected);
    }

    protected void assertResultSet(ResultSet rs, V expectedObj) throws SQLException {
    }

    protected Mapper<K> keyMapper() {
        ((ClassAssert)Assumptions.assumeThat(this.keyClass).as(MAPPER_ERROR_MSG, new Object[0])).isNotNull();
        return Mapper.of(this.keyClass);
    }

    protected Mapper<V> valMapper() {
        ((ClassAssert)Assumptions.assumeThat(this.valueClass).as(MAPPER_ERROR_MSG, new Object[0])).isNotNull();
        return Mapper.of(this.valueClass);
    }
}

