/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.framework.runners;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.DiscoveryUtils;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.apache.ignite.migrationtools.tests.e2e.impl.VeryBasicAbstractCacheTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class Ignite2TestBootStrap {
    private static String CONFIG_URI;
    private static int N_TEST_EXAMPLES;
    private final Supplier<Ignite> clientSupplier;
    private Ignite client = null;

    public Ignite2TestBootStrap() {
        this(Ignite2TestBootStrap::createClient);
    }

    public Ignite2TestBootStrap(Supplier<Ignite> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    private static Ignite createClient() {
        Ignition.setClientMode((boolean)true);
        return Ignition.start((String)CONFIG_URI);
    }

    @BeforeAll
    static void getConfigurationUri() {
        CONFIG_URI = System.getenv("CONFIG_URI");
        if (CONFIG_URI == null) {
            org.junit.jupiter.api.Assertions.fail((String)"CONFIG_URI environment variable is null. Place provide a valid configuration file");
        }
    }

    @BeforeAll
    static void setNumberOfSamples() {
        String numSamples = System.getenv("N_TEST_SAMPLES");
        if (numSamples != null) {
            N_TEST_EXAMPLES = Integer.parseUnsignedInt(numSamples);
        }
    }

    private static Stream<Arguments> provideTestArgs() {
        return DiscoveryUtils.discoverClasses().stream().filter(tc -> tc instanceof VeryBasicAbstractCacheTest).map(tc -> Arguments.of((Object[])new Object[]{Named.named((String)String.format("[%s] - %s", tc.getClass().getSimpleName(), tc.getTableName()), (Object)tc)}));
    }

    @BeforeEach
    void setupClient() {
        this.client = this.clientSupplier.get();
    }

    @AfterEach
    void tearDownClient() {
        this.client.close();
        this.client = null;
    }

    @DisplayName(value="Ignite 2 Java API Tests")
    @ParameterizedTest
    @MethodSource(value={"provideTestArgs"})
    void runTest(ExampleBasedCacheTest test) {
        IgniteCache cache = this.client.cache(test.getTableName());
        Assertions.assertThat((Iterable)cache).isNotNull();
        test.testIgnite2(cache, N_TEST_EXAMPLES);
    }

    static {
        N_TEST_EXAMPLES = 2500;
    }
}

