/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.e2e.framework.runners;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.DiscoveryUtils;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class Ignite2SeedDataTest {
    private static String CONFIG_URI;
    private static int N_TEST_EXAMPLES;
    private static Ignite client;
    private static int nCachesPerStint;
    private int currStint = 0;

    @BeforeAll
    static void getConfigurationUri() {
        CONFIG_URI = System.getenv("CONFIG_URI");
        if (CONFIG_URI == null) {
            Assertions.fail((String)"CONFIG_URI environment variable is null. Place provide a valid configuration file");
        }
    }

    @BeforeAll
    static void setNumberOfSamples() {
        String numSamples = System.getenv("N_TEST_SAMPLES");
        if (numSamples != null) {
            N_TEST_EXAMPLES = Integer.parseUnsignedInt(numSamples);
        }
    }

    @BeforeAll
    static void setNumberOfCachesPerStint() {
        nCachesPerStint = Integer.parseInt(System.getProperty("seeddata.nCachesPerStint", "25"));
    }

    private static Stream<Arguments> provideTestArgs() {
        return DiscoveryUtils.discoverClasses().stream().map(tc -> Arguments.of((Object[])new Object[]{Named.named((String)String.format("[%s] - %s", tc.getClass().getSimpleName(), tc.getTableName()), (Object)tc)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeEach
    void setupClient() {
        Class<Ignite2SeedDataTest> clazz = Ignite2SeedDataTest.class;
        synchronized (Ignite2SeedDataTest.class) {
            if (client == null) {
                Ignition.setClientMode((boolean)true);
                client = Ignition.start((String)CONFIG_URI);
                ClusterState state = client.cluster().state();
                if (state == ClusterState.INACTIVE) {
                    System.out.println("The cluster was not active. Activating..");
                    client.cluster().state(ClusterState.ACTIVE);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @AfterEach
    void rotateClient() {
        if (++this.currStint % nCachesPerStint == 0) {
            Ignite2SeedDataTest.tearDownClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterAll
    static void tearDownClient() {
        Class<Ignite2SeedDataTest> clazz = Ignite2SeedDataTest.class;
        synchronized (Ignite2SeedDataTest.class) {
            if (client != null) {
                client.close();
                client = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestArgs"})
    void seedCache(ExampleBasedCacheTest test) {
        CacheConfiguration cacheCfg = test.cacheConfiguration();
        IgniteCache cache = client.getOrCreateCache(cacheCfg);
        Assertions.assertThat((Iterable)cache).isNotNull();
        this.populateCache(cacheCfg.getName(), arg_0 -> ((ExampleBasedCacheTest)test).supplyExample(arg_0));
    }

    private <K, V> void populateCache(String cacheName, Function<Integer, Map.Entry<K, V>> entrySupplier) {
        try (IgniteDataStreamer streamer = client.dataStreamer(cacheName);){
            streamer.allowOverwrite(true);
            for (int i = 0; i < N_TEST_EXAMPLES; ++i) {
                Map.Entry<K, V> entry = entrySupplier.apply(i);
                streamer.addData(entry.getKey(), entry.getValue());
                if (i <= 0 || i % 10000 != 0) continue;
                System.out.println("Done: " + i);
            }
        }
    }

    static {
        N_TEST_EXAMPLES = 2500;
        client = null;
    }
}

