/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite.migrationtools.config.registry.CombinedConfigRegistry;
import org.apache.ignite.migrationtools.config.storage.NoDefaultsStorageConfiguration;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.RootKey;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.configuration.ConfigurationManager;
import org.apache.ignite3.internal.configuration.ConfigurationModules;
import org.apache.ignite3.internal.configuration.ConfigurationRegistry;
import org.apache.ignite3.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite3.internal.configuration.ServiceLoaderModulesProvider;
import org.apache.ignite3.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite3.internal.configuration.storage.LocalFileConfigurationStorage;
import org.apache.ignite3.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite3.internal.configuration.validation.ConfigurationValidatorImpl;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.security.authentication.validator.AuthenticationProvidersValidatorImpl;
import org.gridgain.internal.license.LicenseContentValidatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ignite3ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ignite3ConfigurationUtils.class);

    public static CombinedConfigRegistry loadCombinedRegistry(Path nodeCfgPath, Path clusterCfgPath, boolean includeDefaults) {
        ConfigurationRegistry locReg = Ignite3ConfigurationUtils.loadNodeConfiguration(nodeCfgPath, includeDefaults);
        ConfigurationRegistry distReg = Ignite3ConfigurationUtils.loadClusterConfiguration(clusterCfgPath, includeDefaults);
        return new CombinedConfigRegistry(locReg, distReg);
    }

    public static ConfigurationRegistry loadNodeConfiguration(Path cfgPath, boolean includeDefaults) {
        return Ignite3ConfigurationUtils.loadConfigurations(cfgPath, Ignite3ConfigurationUtils.loadConfigurationModules().local(), includeDefaults);
    }

    public static ConfigurationRegistry loadClusterConfiguration(Path cfgPath, boolean includeDefaults) {
        ConfigurationModule distributedModule = Ignite3ConfigurationUtils.loadConfigurationModules().distributed();
        for (RootKey key : distributedModule.rootKeys()) {
            try {
                FieldUtils.writeDeclaredField((Object)key, (String)"storageType", (Object)ConfigurationType.LOCAL, (boolean)true);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not override configuration type on key: {}", (Object)key);
            }
        }
        return Ignite3ConfigurationUtils.loadConfigurations(cfgPath, distributedModule, includeDefaults);
    }

    private static ConfigurationRegistry loadConfigurations(Path cfgPath, ConfigurationModule module, boolean includeDefaults) {
        ConfigurationTreeGenerator localConfigurationGenerator = new ConfigurationTreeGenerator(module.rootKeys(), module.schemaExtensions(), module.polymorphicSchemaExtensions());
        LocalFileConfigurationStorage localFileConfigurationStorage = includeDefaults ? new LocalFileConfigurationStorage(cfgPath, localConfigurationGenerator, module) : new NoDefaultsStorageConfiguration(cfgPath, localConfigurationGenerator, module);
        Set myValidators = module.validators().stream().filter(v -> !(v instanceof AuthenticationProvidersValidatorImpl)).filter(v -> !(v instanceof LicenseContentValidatorImpl)).collect(Collectors.toSet());
        ConfigurationValidatorImpl localConfigurationValidator = ConfigurationValidatorImpl.withDefaultValidators((ConfigurationTreeGenerator)localConfigurationGenerator, myValidators);
        ConfigurationManager nodeCfgMgr = new ConfigurationManager(module.rootKeys(), (ConfigurationStorage)localFileConfigurationStorage, localConfigurationGenerator, (ConfigurationValidator)localConfigurationValidator, c -> {}, s -> false);
        nodeCfgMgr.startAsync(new ComponentContext()).join();
        return nodeCfgMgr.configurationRegistry();
    }

    private static ConfigurationModules loadConfigurationModules() {
        ServiceLoaderModulesProvider modulesProvider = new ServiceLoaderModulesProvider();
        List modules = modulesProvider.modules(null);
        if (modules.isEmpty()) {
            throw new IllegalStateException("No configuration modules were loaded, this means Ignite cannot start. Please make sure that the classloader for loading services is correct.");
        }
        return new ConfigurationModules(modules);
    }
}

