/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.sql.FieldNameConflictException;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeDescriptor;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistryMapImpl;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistryUtils;
import org.apache.ignite.migrationtools.types.InspectedField;
import org.apache.ignite.migrationtools.types.InspectedFieldType;
import org.apache.ignite.migrationtools.types.TypeInspector;
import org.apache.ignite.migrationtools.utils.ClassnameUtils;
import org.apache.ignite3.catalog.ColumnType;
import org.apache.ignite3.catalog.definitions.ColumnDefinition;
import org.apache.ignite3.catalog.definitions.TableDefinition;
import org.apache.ignite3.internal.catalog.sql.CatalogExtensions;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDdlGenerator {
    public static final String EXTRA_FIELDS_COLUMN_NAME = "__EXTRA__";
    private static final String[] VALUE_FIELD_NAME_CANDIDATES = new String[]{"VAL", "VAL_OBJ", "TARGET_OBJ"};
    private static final String[] ID_FIELD_NAME_CANDIDATES = new String[]{"ID", "KEY"};
    private static final Set<String> RESERVED_WORDS = Set.of("ABS", "ALL", "ALTER", "AND", "ANY", "ARRAY", "ARRAY_MAX_CARDINALITY", "AS", "ASYMMETRIC", "AVG", "BETWEEN", "BOTH", "BY", "CACHE", "CALL", "CARDINALITY", "CASE", "CAST", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "COALESCE", "COLLECT", "COLUMN", "CONSTRAINT", "CONVERT", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_ROW", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "DATE", "DATETIME", "DECIMAL", "DEFAULT", "DELETE", "DENSE_RANK", "DESCRIBE", "DISTINCT", "DROP", "ELEMENT", "ELSE", "EVERY", "EXCEPT", "EXISTS", "EXP", "EXPLAIN", "EXTEND", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST_VALUE", "FLOOR", "FOR", "FRIDAY", "FROM", "FULL", "FUSION", "GRANTS", "GROUP", "GROUPING", "HAVING", "HOUR", "IDENTIFIED", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "JOIN", "JSON_SCOPE", "LAG", "LAST_VALUE", "LEAD", "LEADING", "LEFT", "LIKE", "LIMIT", "LN", "LOCALTIME", "LOCALTIMESTAMP", "LOWER", "MATCH_RECOGNIZE", "MAX", "MERGE", "MIN", "MINUS", "MINUTE", "MOD", "MONDAY", "MONTH", "MULTISET", "NATURAL", "NEW", "NEXT", "NOT", "NTH_VALUE", "NTILE", "NULL", "NULLIF", "OCTET_LENGTH", "OFFSET", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "PERIOD", "PERMUTE", "POWER", "PRECISION", "PRIMARY", "QUALIFY", "RANK", "REGR_COUNT", "REGR_SXX", "REGR_SYY", "RENAME", "RESET", "RIGHT", "ROLES", "ROLLUP", "ROW", "ROW_NUMBER", "SATURDAY", "SECOND", "SELECT", "SESSION_USER", "SET", "SOME", "SPECIFIC", "SQRT", "STDDEV_POP", "STDDEV_SAMP", "STREAM", "SUBSTRING", "SUM", "SUNDAY", "SYMMETRIC", "SYSTEM_TIME", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "THEN", "THURSDAY", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRUE", "TRUNCATE", "TUESDAY", "UESCAPE", "UNION", "UNKNOWN", "UPDATE", "UPPER", "UPSERT", "USER", "USERS", "USING", "VALUE", "VALUES", "VAR_POP", "VAR_SAMP", "WEDNESDAY", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN", "YEAR");
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlDdlGenerator.class);
    private static final String DEFAULT_SCHEMA = "PUBLIC";
    private static final int DEFAULT_BINARY_FIELD_LENGTH = 1024;
    private final ClassLoader clientClassLoader;
    private final TableTypeRegistry tableTypeRegistry;
    private final boolean allowExtraFields;

    public SqlDdlGenerator() {
        this(new TableTypeRegistryMapImpl());
    }

    public SqlDdlGenerator(TableTypeRegistry tableTypeRegistry) {
        this(tableTypeRegistry, false);
    }

    public SqlDdlGenerator(TableTypeRegistry tableTypeRegistry, boolean allowExtraFields) {
        this(SqlDdlGenerator.class.getClassLoader(), tableTypeRegistry, allowExtraFields);
    }

    public SqlDdlGenerator(ClassLoader clientClassLoader, TableTypeRegistry tableTypeRegistry, boolean allowExtraFields) {
        this.clientClassLoader = clientClassLoader;
        this.tableTypeRegistry = tableTypeRegistry;
        this.allowExtraFields = allowExtraFields;
    }

    private static void addToQueryEntity(QueryEntity qe, String columnName, String typeName, InspectedFieldType fieldType, boolean nullable) {
        if (fieldType == InspectedFieldType.ARRAY) {
            qe.getFieldsPrecision().putIfAbsent(columnName, 1024);
        }
        if (!nullable) {
            qe.getNotNullFields().add(columnName);
        }
        qe.getFields().put(columnName, typeName);
    }

    private static String sanitizeColumnName(String columnName) {
        if (columnName.startsWith("\"")) {
            return columnName;
        }
        String uppercaseColumnName = columnName.toUpperCase();
        return RESERVED_WORDS.contains(uppercaseColumnName) ? "\"" + uppercaseColumnName + "\"" : columnName;
    }

    public static String createDdlQuery(TableDefinition def) {
        return SqlDdlGenerator.createDdlQuery(Collections.singletonList(def));
    }

    public static String createDdlQuery(List<TableDefinition> defs) {
        return defs.stream().map(CatalogExtensions::sqlFromTableDefinition).collect(Collectors.joining("\n\n"));
    }

    @Nullable
    private static Map.Entry<String, String> keyField(QueryEntity qe) {
        String fname = qe.getKeyFieldName();
        return fname != null ? Map.entry(fname, qe.getKeyType()) : null;
    }

    @Nullable
    private static Map.Entry<String, String> valField(QueryEntity qe) {
        String fname = qe.getValueFieldName();
        return fname != null ? Map.entry(fname, qe.getValueType()) : null;
    }

    private List<InspectedField> inspectTypeName(String typeName, String typeDescr) {
        try {
            Class type = ClassUtils.getClass((ClassLoader)this.clientClassLoader, (String)typeName);
            return TypeInspector.inspectType(type);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Could not find {} class to enrich the QueryEntity: {}", (Object)typeDescr, (Object)typeName);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private QueryEntityEvaluation populateQueryEntity(QueryEntity qe, boolean allowExtraFields) throws FieldNameConflictException {
        String columnName;
        Object inspectedField;
        boolean mapsPojo;
        void var4_8;
        HashMap<InspectedField, String> keyFieldToColumnMap;
        if (qe.getNotNullFields() == null) {
            qe.setNotNullFields(new HashSet());
        }
        if (qe.getKeyFields() == null) {
            qe.setKeyFields(new HashSet());
        }
        if (qe.getFieldsPrecision() == null) {
            qe.setFieldsPrecision(new HashMap());
        }
        for (Map.Entry entry : qe.getFields().entrySet()) {
            entry.setValue(ClassnameUtils.ensureWrapper((String)entry.getValue()));
        }
        List keyFields = qe.getFields().entrySet().stream().filter(f -> qe.getKeyFields().contains(f.getKey())).collect(Collectors.toList());
        @Nullable String string = qe.getKeyFieldName();
        if (string != null) {
            @Nullable String foundType = qe.findKeyType();
            if (foundType == null) {
                throw FieldNameConflictException.forSpecificField("key", string);
            }
            qe.getFields().put(string, ClassnameUtils.ensureWrapper(foundType));
            qe.getKeyFields().add(string);
        } else if (keyFields.size() == 1) {
            qe.setKeyFieldName((String)((Map.Entry)keyFields.get(0)).getKey());
            qe.setKeyType((String)((Map.Entry)keyFields.get(0)).getValue());
        }
        List valueFields = qe.getFields().entrySet().stream().filter(f -> !qe.getKeyFields().contains(f.getKey())).collect(Collectors.toList());
        @Nullable String valFieldName = qe.getValueFieldName();
        if (valFieldName != null) {
            @Nullable String foundType = qe.findValueType();
            if (foundType == null) {
                throw FieldNameConflictException.forSpecificField("value", valFieldName);
            }
            qe.getFields().put(valFieldName, ClassnameUtils.ensureWrapper(foundType));
        } else if (valueFields.size() == 1) {
            qe.setValueFieldName((String)((Map.Entry)valueFields.get(0)).getKey());
            qe.setValueType((String)((Map.Entry)valueFields.get(0)).getValue());
        }
        qe.getNotNullFields().addAll(qe.getKeyFields());
        Predicate<InspectedField> isNestedPojo = f -> f.fieldType() != InspectedFieldType.NESTED_POJO_ATTRIBUTE;
        List<InspectedField> keyFields2 = this.inspectTypeName(qe.getKeyType(), "KEY");
        if (keyFields2.isEmpty()) {
            keyFieldToColumnMap = null;
        } else {
            keyFields2 = keyFields2.stream().filter(isNestedPojo).collect(Collectors.toList());
            keyFieldToColumnMap = new HashMap<InspectedField, String>();
        }
        List<InspectedField> valFields = this.inspectTypeName(qe.getValueType(), "VALUE");
        if (valFields.isEmpty()) {
            Object var4_6 = null;
        } else {
            valFields = valFields.stream().filter(isNestedPojo).collect(Collectors.toList());
            @Nullable HashMap<K, V> hashMap = new HashMap();
        }
        HashSet<String> fieldNames = new HashSet<String>(qe.getFields().size() + keyFields2.size() + valFields.size());
        class Entry {
            private final InspectedField inspectedField;
            private final Supplier<Map.Entry<String, String>> keyFieldSupplier;
            private final Supplier<String> fieldNameCandidateSupplier;
            private final Map<InspectedField, String> fieldToColumnMap;

            private Entry(InspectedField inspectedField, Supplier<Map.Entry<String, String>> keyFieldSupplier, Supplier<String> fieldNameCandidateSupplier, Map<InspectedField, String> fieldToColumnMap) {
                this.inspectedField = inspectedField;
                this.keyFieldSupplier = keyFieldSupplier;
                this.fieldNameCandidateSupplier = fieldNameCandidateSupplier;
                this.fieldToColumnMap = fieldToColumnMap;
            }
        }
        ArrayList<Entry> unnamedFields = new ArrayList<Entry>(keyFields2.size() + valFields.size());
        FieldNameCandidateSupplier keyFieldNameCandidates = new FieldNameCandidateSupplier(ID_FIELD_NAME_CANDIDATES, n -> "KEY_" + n);
        FieldNameCandidateSupplier valFieldCandidates = new FieldNameCandidateSupplier(VALUE_FIELD_NAME_CANDIDATES, n -> "VAL_" + n);
        Function<InspectedField, Entry> keyMapper = arg_0 -> this.lambda$populateQueryEntity$6(qe, (Supplier)keyFieldNameCandidates, keyFieldToColumnMap, arg_0);
        Function<InspectedField, Entry> valMapper = arg_0 -> this.lambda$populateQueryEntity$8(qe, (Supplier)valFieldCandidates, (Map)var4_8, arg_0);
        Stream x = Stream.of(keyFields2.stream().filter(InspectedField::hasAnnotation).map(keyMapper), valFields.stream().filter(InspectedField::hasAnnotation).map(valMapper), keyFields2.stream().filter(Predicate.not(InspectedField::hasAnnotation)).map(keyMapper), valFields.stream().filter(Predicate.not(InspectedField::hasAnnotation)).map(valMapper)).flatMap(s -> s);
        Stream.concat(qe.getFields().keySet().stream(), qe.getAliases().values().stream()).map(String::toUpperCase).forEach(fieldNames::add);
        Iterator it = x.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            InspectedField inspectedField2 = entry.inspectedField;
            @Nullable String fieldName = inspectedField2.fieldName();
            if (fieldName != null) {
                String fieldNameUpperCase = fieldName.toUpperCase();
                if (!fieldNames.contains(fieldNameUpperCase)) {
                    fieldNames.add(fieldNameUpperCase);
                    entry.fieldToColumnMap.put(inspectedField2, fieldName);
                    continue;
                }
                Optional<Map.Entry> existingEntryForField = qe.getFields().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(fieldName) && ((String)e.getValue()).equals(inspectedField2.typeName())).findFirst();
                if (existingEntryForField.isPresent()) {
                    entry.fieldToColumnMap.put(inspectedField2, (String)existingEntryForField.get().getKey());
                    continue;
                }
                unnamedFields.add(entry);
                continue;
            }
            if (inspectedField2.fieldType() == InspectedFieldType.PRIMITIVE) {
                Map.Entry<String, String> field = entry.keyFieldSupplier.get();
                if (field == null) {
                    unnamedFields.add(entry);
                    continue;
                }
                if (inspectedField2.typeName().equals(field.getValue())) {
                    entry.fieldToColumnMap.put(inspectedField2, field.getKey());
                    continue;
                }
                throw FieldNameConflictException.forSpecificField(fieldName, inspectedField2.typeName(), field.getValue());
            }
            unnamedFields.add(entry);
        }
        for (Entry unnamedEntry : unnamedFields) {
            String fieldName = Stream.generate(unnamedEntry.fieldNameCandidateSupplier).filter(Predicate.not(fieldNames::contains)).findFirst().get();
            fieldNames.add(fieldName);
            unnamedEntry.fieldToColumnMap.put(unnamedEntry.inspectedField, fieldName);
        }
        boolean bl = mapsPojo = keyFields2.isEmpty() || valFields.isEmpty();
        if (keyFields2.size() == 1) {
            inspectedField = keyFields2.get(0);
            String columnName2 = (String)keyFieldToColumnMap.get(inspectedField);
            qe.setKeyFieldName(columnName2);
            qe.setKeyType(((InspectedField)inspectedField).typeName());
        }
        for (InspectedField inspectedField3 : keyFields2) {
            columnName = (String)keyFieldToColumnMap.get(inspectedField3);
            qe.getKeyFields().add(columnName);
            SqlDdlGenerator.addToQueryEntity(qe, columnName, inspectedField3.typeName(), inspectedField3.fieldType(), false);
            mapsPojo = mapsPojo || inspectedField3.fieldType() == InspectedFieldType.POJO_ATTRIBUTE;
        }
        if (valFields.size() == 1) {
            inspectedField = valFields.get(0);
            String columnName2 = (String)var4_8.get(inspectedField);
            qe.setValueFieldName(columnName2);
            qe.setValueType(((InspectedField)inspectedField).typeName());
        }
        for (InspectedField inspectedField2 : valFields) {
            columnName = (String)var4_8.get(inspectedField2);
            SqlDdlGenerator.addToQueryEntity(qe, columnName, inspectedField2.typeName(), inspectedField2.fieldType(), inspectedField2.nullable());
            mapsPojo = mapsPojo || inspectedField2.fieldType() == InspectedFieldType.POJO_ATTRIBUTE;
        }
        if (mapsPojo && allowExtraFields) {
            qe.getFieldsPrecision().putIfAbsent(EXTRA_FIELDS_COLUMN_NAME, 1024);
            qe.getFields().put(EXTRA_FIELDS_COLUMN_NAME, byte[].class.getName());
        }
        return new QueryEntityEvaluation(qe, keyFieldToColumnMap, (Map<InspectedField, String>)var4_8);
    }

    public GenerateTableResult generate(CacheConfiguration<?, ?> cacheCfg) throws FieldNameConflictException {
        String schema = Optional.ofNullable(cacheCfg.getSqlSchema()).orElse(DEFAULT_SCHEMA);
        String tableName = "\"" + cacheCfg.getName() + "\"";
        QueryEntityEvaluation queryEntityEvaluation = this.getOrCreateQueryEntity(cacheCfg);
        QueryEntity qryEntity = queryEntityEvaluation.queryEntity;
        int defIdx = 0;
        int pkIdx = 0;
        String[] pkColumnNames = new String[qryEntity.getKeyFields().size()];
        ColumnDefinition[] colDefinitions = new ColumnDefinition[qryEntity.getFields().size()];
        for (Map.Entry entry : qryEntity.getFields().entrySet()) {
            Class<Enum> klass;
            String fieldName = (String)entry.getKey();
            try {
                klass = ClassUtils.getClass((ClassLoader)this.clientClassLoader, (String)((String)entry.getValue()));
                if (klass.isEnum()) {
                    klass = Enum.class;
                }
            }
            catch (ClassNotFoundException e) {
                throw FieldNameConflictException.forUnknownType(fieldName, (String)entry.getValue());
            }
            Integer precision = (Integer)qryEntity.getFieldsPrecision().get(fieldName);
            Integer scale = (Integer)qryEntity.getFieldsScale().get(fieldName);
            ColumnType colType = ColumnType.of(klass).length(precision).precision(precision, scale).nullable(Boolean.valueOf(!qryEntity.getNotNullFields().contains(fieldName)));
            String dirtyColumnName = qryEntity.getAliases().getOrDefault(fieldName, fieldName);
            String columnName = SqlDdlGenerator.sanitizeColumnName(dirtyColumnName);
            colDefinitions[defIdx++] = ColumnDefinition.column((String)columnName, (ColumnType)colType);
            if (!qryEntity.getKeyFields().contains(fieldName)) continue;
            pkColumnNames[pkIdx++] = columnName;
        }
        Function<@Nullable Map, @Nullable Map> processFieldToColumnMap = map -> {
            if (map == null) {
                return null;
            }
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry e : map.entrySet()) {
                @Nullable String fieldName = ((InspectedField)e.getKey()).fieldName();
                if (fieldName == null) continue;
                String columnName = (String)e.getValue();
                columnName = qryEntity.getAliases().getOrDefault(columnName, columnName);
                ret.put(columnName, fieldName);
            }
            return ret;
        };
        @Nullable Map keyFieldForColumn = processFieldToColumnMap.apply(queryEntityEvaluation.keyInspectedFieldMap);
        @Nullable Map valFieldForColumn = processFieldToColumnMap.apply(queryEntityEvaluation.valInspectedFieldMap);
        TableDefinition table = TableDefinition.builder((String)tableName).schema(schema).columns(colDefinitions).primaryKey(pkColumnNames).build();
        return new GenerateTableResult(table, new TableTypeDescriptor(qryEntity.getKeyType(), qryEntity.getValueType(), keyFieldForColumn, valFieldForColumn));
    }

    public TableDefinition generateTableDefinition(CacheConfiguration<?, ?> cacheCfg) throws FieldNameConflictException {
        return this.generate(cacheCfg).tableDefinition;
    }

    private QueryEntityEvaluation getOrCreateQueryEntity(CacheConfiguration cacheCfg) throws FieldNameConflictException {
        QueryEntity qe;
        Map.Entry<Class<?>, Class<?>> typeHints = null;
        try {
            @Nullable TableTypeDescriptor tableDescriptor = this.tableTypeRegistry.typesForTable(cacheCfg.getName());
            if (tableDescriptor != null) {
                typeHints = TableTypeRegistryUtils.typesToEntry(tableDescriptor);
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("Found TableTypeHint for cache but one of the class was not in the Classpath: {}", (Object)cacheCfg.getName(), (Object)ex);
        }
        if (typeHints != null) {
            LOGGER.warn("Found TableTypeHint for cache: {}:{}", (Object)cacheCfg.getName(), typeHints);
            qe = new QueryEntity(typeHints.getKey(), typeHints.getValue());
        } else if (cacheCfg.getQueryEntities().isEmpty()) {
            qe = new QueryEntity();
            String binaryClsName = byte[].class.getName();
            qe.setKeyType(binaryClsName);
            qe.setValueType(binaryClsName);
            HashMap<String, Integer> precision = new HashMap<String, Integer>();
            precision.put("ID", 1024);
            precision.put("VAL", 1024);
            qe.setFieldsPrecision(precision);
        } else if (cacheCfg.getQueryEntities().size() == 1) {
            qe = new QueryEntity((QueryEntity)cacheCfg.getQueryEntities().iterator().next());
        } else {
            LOGGER.warn("Unexpected number of entities (Only 0, 1 QueryEntity is support ATM): {}:{}", (Object)cacheCfg.getName(), (Object)cacheCfg.getQueryEntities().size());
            throw new RuntimeException("Unsupported number of queryEntities in cache configuration: " + cacheCfg.getQueryEntities().size());
        }
        return this.populateQueryEntity(qe, this.allowExtraFields);
    }

    private /* synthetic */ 1Entry lambda$populateQueryEntity$8(QueryEntity qe, Supplier valFieldCandidates, Map valFieldToColumnMap, InspectedField f) {
        return new Entry(f, () -> SqlDdlGenerator.valField(qe), valFieldCandidates, valFieldToColumnMap);
    }

    private /* synthetic */ 1Entry lambda$populateQueryEntity$6(QueryEntity qe, Supplier keyFieldNameCandidates, Map keyFieldToColumnMap, InspectedField f) {
        return new Entry(f, () -> SqlDdlGenerator.keyField(qe), keyFieldNameCandidates, keyFieldToColumnMap);
    }

    private static class FieldNameCandidateSupplier
    implements Supplier<String> {
        private final String[] base;
        private final Function<Integer, String> additional;
        private int idx;

        public FieldNameCandidateSupplier(String[] base, Function<Integer, String> additional) {
            this.base = base;
            this.additional = additional;
            this.idx = 0;
        }

        @Override
        public String get() {
            String ret = this.idx < this.base.length ? this.base[this.idx] : this.additional.apply(this.idx - this.base.length);
            ++this.idx;
            return ret;
        }
    }

    static class QueryEntityEvaluation {
        private final QueryEntity queryEntity;
        @Nullable
        private final Map<InspectedField, String> keyInspectedFieldMap;
        @Nullable
        private final Map<InspectedField, String> valInspectedFieldMap;

        QueryEntityEvaluation(QueryEntity queryEntity, @Nullable Map<InspectedField, String> keyInspectedFieldMap, @Nullable Map<InspectedField, String> valInspectedFieldMap) {
            this.queryEntity = queryEntity;
            this.keyInspectedFieldMap = keyInspectedFieldMap;
            this.valInspectedFieldMap = valInspectedFieldMap;
        }
    }

    public static class GenerateTableResult {
        private final TableDefinition tableDefinition;
        private final TableTypeDescriptor tableTypeDescriptor;

        public GenerateTableResult(TableDefinition tableDefinition, TableTypeDescriptor tableTypeDescriptor) {
            this.tableDefinition = tableDefinition;
            this.tableTypeDescriptor = tableTypeDescriptor;
        }

        public TableDefinition tableDefinition() {
            return this.tableDefinition;
        }

        public TableTypeDescriptor tableTypeDescriptor() {
            return this.tableTypeDescriptor;
        }

        public Map.Entry<String, String> typeHints() {
            return this.tableTypeDescriptor.typeHints();
        }

        public Map<String, String> fieldToColumnMappings() {
            HashMap<String, String> ret = new HashMap<String, String>();
            Optional.ofNullable(this.tableTypeDescriptor.keyFieldNameForColumn()).ifPresent(ret::putAll);
            Optional.ofNullable(this.tableTypeDescriptor.valFieldNameForColumn()).ifPresent(ret::putAll);
            return ret;
        }
    }
}

