/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.sql;

import java.util.Set;
import org.apache.ignite.migrationtools.types.InspectedField;

public class FieldNameConflictException
extends RuntimeException {
    private FieldNameConflictException(String message) {
        super(message);
    }

    public FieldNameConflictException(InspectedField inspectedField, Set<String> knownFieldNames) {
        super("Duplicated field name for:" + String.valueOf(inspectedField) + " in " + String.valueOf(knownFieldNames));
    }

    public static FieldNameConflictException forSpecificField(String fieldName, String expectedValue, String foundValue) {
        return new FieldNameConflictException(String.format("Unexpected type for field: %s - Expected:%s Found:%s", fieldName, expectedValue, foundValue));
    }

    public static FieldNameConflictException forSpecificField(String label, String fieldName) {
        return new FieldNameConflictException(String.format("Unexpected null type for %s field with name: %s", label, fieldName));
    }

    public static FieldNameConflictException forUnknownType(String fieldName, String fieldType) {
        return new FieldNameConflictException(String.format("Unknown non-native type for field: %s - %s. Consider adding this type to the classpath.", fieldName, fieldType));
    }
}

