/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BooleanSupplier;
import org.apache.ignite.migrationtools.tests.clusters.FullSampleCluster;
import org.apache.ignite.migrationtools.tests.containers.Ignite2ClusterContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.utility.MountableFile;

public abstract class Ignite2ClusterWithSamples
implements BeforeAllCallback {
    private final Path targetPath;

    public Ignite2ClusterWithSamples(Path targetPath) {
        this.targetPath = targetPath;
    }

    public static boolean waitForCondition(BooleanSupplier cond, long sleepMillis, long timeoutMillis) throws InterruptedException {
        long stop = System.currentTimeMillis() + timeoutMillis;
        while (System.currentTimeMillis() < stop) {
            if (cond.getAsBoolean()) {
                return true;
            }
            Thread.sleep(sleepMillis);
        }
        return false;
    }

    protected abstract Ignite2ClusterContainer createClusterContainers();

    private void recreateClusterFolder() throws InterruptedException, IOException {
        System.out.println("Recreating the sample-cluster");
        System.out.println("Current Directory; " + Path.of(".", new String[0]).toAbsolutePath().toString());
        Files.createDirectory(this.targetPath, new FileAttribute[0]);
        try (Ignite2ClusterContainer cluster = this.createClusterContainers();){
            cluster.start();
            try (OutputStream seedLogOs = Files.newOutputStream(this.targetPath.resolve("seeddata-container.log"), new OpenOption[0]);){
                Network clusterNetwork = cluster.getNetwork();
                try (GenericContainer seedDataContainer = this.createSeedDataCountainer(clusterNetwork);){
                    seedDataContainer.start();
                    seedDataContainer.followOutput(frame -> {
                        if (frame.getType() != OutputFrame.OutputType.END) {
                            try {
                                seedLogOs.write(frame.getBytes());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    int maxWaitSeconds = Integer.parseInt(System.getProperty("ai2.sampleCluster.recreate.seeding.maxwaitseconds", "7200"));
                    int pollingSeconds = Integer.parseInt(System.getProperty("ai2.sampleCluster.recreate.seeding.pollingseconds", "180"));
                    boolean success = Ignite2ClusterWithSamples.waitForCondition(() -> !seedDataContainer.isRunning(), pollingSeconds * 1000, maxWaitSeconds * 1000);
                    InspectContainerResponse.ContainerState state = seedDataContainer.getContainerInfo().getState();
                    System.out.println("Seed data status: " + state);
                    Assertions.assertTrue((boolean)success, (String)"Timeout waiting for seed data to finish.");
                    Assertions.assertEquals((long)0L, (Long)state.getExitCodeLong(), (String)"Seed data container exit code is not 0");
                    System.out.println("Finished waiting for seed data container to run");
                }
            }
            System.out.println("Stopping the containers");
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (!Files.exists(this.targetPath, new LinkOption[0])) {
            this.recreateClusterFolder();
        }
    }

    protected GenericContainer createSeedDataCountainer(Network network) {
        String imageName = System.getProperty("migrationtools.e2erunner.docker.image");
        if (imageName == null) {
            throw new IllegalArgumentException("'migrationtools.e2erunner.docker.image' property must be defined");
        }
        return new GenericContainer(imageName).withCopyFileToContainer(MountableFile.forHostPath((Path)FullSampleCluster.CLUSTER_CFG_PATH), "/opt/app/config.xml").withNetwork(network);
    }
}

