/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.bases;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.migrationtools.tests.clusters.FullSampleCluster;
import org.apache.ignite.migrationtools.tests.containers.Ignite3ClusterContainer;
import org.apache.ignite.migrationtools.tests.containers.MigrationToolsContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.extension.ExtendWith;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecConfig;
import org.testcontainers.containers.Network;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@DisabledIfSystemProperty(named="tests.containers.support", matches="false", disabledReason="Lack of support in TeamCity for testcontainers")
@ExtendWith(value={FullSampleCluster.class})
@Testcontainers
public class MigrationTestBase {
    private static final Logger LOGGER = LogManager.getLogger(MigrationTestBase.class);
    private static boolean DEBUG_MODE = Boolean.parseBoolean(System.getProperty("debugMode", "false"));
    private static final Path MIGRATION_TOOLS_CLI_FOLDER = Path.of("target/dependency/migration-tools-cli.jar", new String[0]);
    protected static final List<String> NODE_NAMES = List.of("ad26bff6-5ff5-49f1-9a61-425a827953ed", "c1099d16-e7d7-49f4-925c-53329286c444", "7b880b69-8a9e-4b84-b555-250d365e2e67");
    protected static final Network network = Network.newNetwork();
    @Container
    protected static final Ignite3ClusterContainer AI3_CLUSTER = new Ignite3ClusterContainer(network).withLabel(MigrationTestBase.class.getSimpleName());
    @Container
    protected static final MigrationToolsContainer MIGRATION_TOOLS_CONTAINER = new MigrationToolsContainer(network);

    @AfterAll
    static void tearDownNetwork() {
        if (network != null) {
            network.close();
        }
    }

    public static void migrationIsSuccessfull(String cacheName, String migrationMode) throws IOException, InterruptedException {
        String clusterAddress = "ai3.node.1:10800";
        Path logsFolder = Path.of("build/test-logs/", new String[0]);
        if (!Files.isDirectory(logsFolder, new LinkOption[0])) {
            Files.createDirectory(logsFolder, new FileAttribute[0]);
        }
        for (int i = 0; i < NODE_NAMES.size(); ++i) {
            Container.ExecResult execResult = MigrationTestBase.migrateCache(MIGRATION_TOOLS_CONTAINER, i, cacheName, migrationMode, clusterAddress, null, logsFolder);
            ((AbstractIntegerAssert)Assertions.assertThat((int)execResult.getExitCode()).as("Migration command should have finished successfully", new Object[0])).isZero();
        }
    }

    public static Container.ExecResult migrateCache(MigrationToolsContainer migrationToolsContainer, int nodeIdx, String cacheName, String migrationMode, String clusterAddress, @Nullable Map.Entry<String, String> credentials, Path logsFolder) throws IOException, InterruptedException {
        String nodeId = NODE_NAMES.get(nodeIdx);
        String fmt = "migration-%s-%d.%s";
        Path logPath = logsFolder.resolve(Path.of(String.format(fmt, cacheName, nodeIdx, "log"), new String[0]));
        Path stdoutPath = logsFolder.resolve(Path.of(String.format(fmt, cacheName, nodeIdx, "stdout"), new String[0]));
        Path stderrPath = logsFolder.resolve(Path.of(String.format(fmt, cacheName, nodeIdx, "stderr"), new String[0]));
        try (OutputStream outStream = Files.newOutputStream(stdoutPath, new OpenOption[0]);){
            Container.ExecResult execResult;
            block13: {
                OutputStream errStream = Files.newOutputStream(stderrPath, new OpenOption[0]);
                try {
                    long startTime = System.currentTimeMillis();
                    ArrayList<String> arguments = new ArrayList<String>(List.of("migration-tools", "persistent-data", "/storage", nodeId, "/config-file.xml", "migrate-cache", cacheName, clusterAddress, "--mode", migrationMode));
                    ExecConfig.ExecConfigBuilder execConfigBuilder = ExecConfig.builder();
                    if (credentials != null) {
                        arguments.add("--client.basicAuthenticator.username");
                        arguments.add(credentials.getKey());
                        execConfigBuilder.envVars(Map.of("IGNITE_CLIENT_SECRET", credentials.getValue()));
                    }
                    execConfigBuilder.command((String[])arguments.toArray(String[]::new));
                    ExecConfig execConfig = execConfigBuilder.build();
                    Container.ExecResult migrationCmd = migrationToolsContainer.execInContainer(execConfig);
                    long finishTime = System.currentTimeMillis() - startTime;
                    outStream.write(migrationCmd.getStdout().getBytes(StandardCharsets.UTF_8));
                    errStream.write(migrationCmd.getStderr().getBytes(StandardCharsets.UTF_8));
                    migrationToolsContainer.copyFileFromContainer("/root/.ignite-migration-tools/logs/ignite-0.log", logPath.toString());
                    LOGGER.info("Finished migrating cache: {};{};{};{}", (Object)nodeId, (Object)cacheName, (Object)migrationMode, (Object)finishTime);
                    execResult = migrationCmd;
                    if (errStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (errStream != null) {
                        try {
                            errStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                errStream.close();
            }
            return execResult;
        }
    }
}

