/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.containers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.ignite.migrationtools.tests.clusters.FullSampleCluster;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecConfig;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.MountableFile;

public class MigrationToolsContainer
implements Startable {
    public final GenericContainer container;

    public MigrationToolsContainer(Network network) {
        String imageName = System.getProperty("migrationtools.cli.docker.image");
        if (imageName == null) {
            throw new IllegalArgumentException("'migrationtools.cli.docker.image' property must be defined");
        }
        this.container = new GenericContainer(imageName).withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"/bin/bash"})).withNetwork(network).withCommand(new String[]{"-c", "sleep infinity"}).withCopyFileToContainer(MountableFile.forHostPath((Path)FullSampleCluster.CLUSTER_CFG_PATH), "/config-file.xml").withFileSystemBind(FullSampleCluster.TEST_CLUSTER_PATH.toString(), "/storage", BindMode.READ_WRITE).withEnv("CONFIG_URI", "/config-file.xml");
    }

    public MigrationToolsContainer withDebug() {
        this.container.addEnv("EXTRA_JVM_OPTS", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5005");
        this.container.setPortBindings(Collections.singletonList("5005:5005"));
        return this;
    }

    public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(command);
    }

    public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(outputCharset, command);
    }

    public Container.ExecResult execInContainer(ExecConfig execConfig) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(execConfig);
    }

    public Container.ExecResult execInContainer(Charset outputCharset, ExecConfig execConfig) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(outputCharset, execConfig);
    }

    public void copyFileFromContainer(String containerPath, String destinationPath) {
        this.container.copyFileFromContainer(containerPath, destinationPath);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }
}

