/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.containers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.client.IgniteClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.MountableFile;

public class Ignite3ClusterContainer
implements Startable {
    private static final Logger LOGGER = LogManager.getLogger(Ignite3ClusterContainer.class);
    private final GenericContainer<?> node;
    private BufferedWriter logWriter;
    @Nullable
    private Map.Entry<String, String> credentials;
    @Nullable
    private String label = null;

    public Ignite3ClusterContainer() {
        this(Network.newNetwork());
    }

    public Ignite3ClusterContainer(Network network) {
        String imageName = Ignite3ClusterContainer.dockerImageName();
        this.node = new GenericContainer(imageName).withNetwork(network).withNetworkAliases(new String[]{"ai3.node.1"}).withCommand("--node-name clusterNode1").withExposedPorts(new Integer[]{10800}).withCopyFileToContainer(MountableFile.forHostPath((String)"../../../modules/core/src/testFixtures/resources/gridgain-license.json"), "/opt/gridgain9/gridgain-license.conf").waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Components started.*", (int)1));
    }

    public Ignite3ClusterContainer withCredentials(@Nullable Map.Entry<String, String> credentials) {
        this.credentials = credentials;
        return this;
    }

    public Ignite3ClusterContainer withDebug() {
        this.node.addEnv("IGNITE3_EXTRA_JVM_ARGS", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:8000");
        this.node.addExposedPort(Integer.valueOf(8000));
        return this;
    }

    public Ignite3ClusterContainer withLabel(String label) {
        this.label = label;
        this.node.withLabel("org.apache.ignite.migrationtools.label", label);
        return this;
    }

    public void start() {
        this.node.start();
        Path parentFolder = Path.of("build/test-logs", new String[0]);
        String label = this.label == null ? "" : "-" + this.label;
        Path logFilePath = parentFolder.resolve("ignite-3" + label + "-" + this.node.getContainerId().substring(0, 8));
        CountDownLatch startupLatch = new CountDownLatch(1);
        try {
            Container.ExecResult execRes;
            Files.createDirectories(parentFolder, new FileAttribute[0]);
            this.logWriter = Files.newBufferedWriter(logFilePath, new OpenOption[0]);
            this.node.followOutput(frame -> {
                OutputFrame.OutputType type = frame.getType();
                if (type == OutputFrame.OutputType.STDOUT || type == OutputFrame.OutputType.STDERR) {
                    String msg = frame.getUtf8String();
                    try {
                        this.logWriter.write(msg);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error writing cluster logs to file: ", (Throwable)e);
                    }
                    if (msg.contains("[IgniteServerImpl] GridGain started successfully!")) {
                        startupLatch.countDown();
                    }
                }
            });
            ArrayList<String> args = new ArrayList<String>(List.of("/opt/gridgain9cli/bin/gridgain9", "cluster", "init", "--name=ignite-cluster", "--url=http://127.0.0.1:10300", "--metastorage-group=clusterNode1", "--license=/opt/gridgain9/gridgain-license.conf"));
            if (this.credentials != null) {
                String credentialsArg = String.format("--config=ignite{security{enabled:true,authentication.providers:[{name:default,type:basic,users:[{displayName:administrator,username:%s,password:%s,roles:[system]}]}]}}", this.credentials.getKey(), this.credentials.getValue());
                args.add(credentialsArg);
            }
            if ((execRes = this.node.execInContainer((String[])args.toArray(String[]::new))).getExitCode() != 0) {
                throw new RuntimeException("Could not init cluster: " + execRes.getStderr());
            }
            boolean started = startupLatch.await(10000L, TimeUnit.MILLISECONDS);
            if (!started) {
                throw new RuntimeException("Failed to catch cluster started signal after cluster init");
            }
        }
        catch (IOException | InterruptedException | RuntimeException ex) {
            this.stop();
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    public void stop() {
        this.node.stop();
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (IOException e) {
                LOGGER.error("Exception closing the cluster log file: ", (Throwable)e);
            }
        }
    }

    public String getInternalAddress() {
        return (String)this.node.getNetworkAliases().get(0) + ":10800";
    }

    public String getAddress() {
        return this.node.getHost() + ":" + this.node.getFirstMappedPort();
    }

    public IgniteClient.Builder clientBuilder() {
        return IgniteClient.builder().addresses(new String[]{this.getAddress()});
    }

    public IgniteClient buildClient() {
        return this.clientBuilder().build();
    }

    public static String dockerImageName() {
        String imageName = System.getProperty("ignite3.docker.image");
        if (imageName == null) {
            throw new IllegalArgumentException("ignite3.docker.image property must be defined");
        }
        return imageName;
    }

    public GenericContainer<?> node() {
        return this.node;
    }
}

