/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.handlers;

import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class SkipUnsupportedOperationsHandlers
implements TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (throwable instanceof UnsupportedOperationException && throwable.getMessage().contains("Only SqlFieldsQuery and ScanQueries are currently supported.")) {
            Assumptions.abort((String)"This test requires support for old SQLQueries. (TODO: GG-44626)");
            return;
        }
        if (throwable instanceof UnsupportedOperationException && throwable.getMessage().contains("Query with _KEY and _VAL columns is not supported")) {
            Assumptions.abort((String)"This test requires support for ai2 internal columns (TODO: GG-40624)");
            return;
        }
        if (throwable instanceof RuntimeException && throwable.getMessage().contains("org.apache.calcite.sql.parser.SqlParseException: Encountered \"REGEXP\"")) {
            Assumptions.abort((String)"This test requires support for H2 REGEXP operator (TODO: GG-40623)");
            return;
        }
        throw throwable;
    }
}

